/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.optimizer.resource.handler.impl;

import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.context.FacesContext;
import org.richfaces.resource.ResourceFactory;
import org.richfaces.resource.ResourceKey;
import org.richfaces.resource.ResourceRequestData;
import org.richfaces.resource.ResourceUtils;
import org.richfaces.resource.optimizer.resource.handler.impl.AbstractResourceHandler;
import org.richfaces.resource.optimizer.resource.handler.impl.DynamicResourceWrapper;

public class DynamicResourceHandler
extends AbstractResourceHandler {
    private ResourceFactory resourceFactory;
    private ResourceHandler staticResourceHandler;

    public DynamicResourceHandler(ResourceHandler staticResourceHandler, ResourceFactory resourceFactory) {
        this.staticResourceHandler = staticResourceHandler;
        this.resourceFactory = resourceFactory;
    }

    @Override
    public Resource createResource(String resourceName, String libraryName, String contentType) {
        Object state;
        FacesContext context;
        Resource newResource;
        ResourceKey resourceKey = new ResourceKey(resourceName, libraryName);
        Resource result = this.resourceFactory.createResource(resourceName, libraryName, contentType);
        if (result != null && (newResource = this.resourceFactory.createResource(context = FacesContext.getCurrentInstance(), new ResourceRequestDataImpl(resourceKey, state = ResourceUtils.saveResourceState(context, result)))) != null) {
            result = new DynamicResourceWrapper(newResource);
        }
        if (result == null) {
            result = this.staticResourceHandler.createResource(resourceName, libraryName, contentType);
        }
        return result;
    }

    private static final class ResourceRequestDataImpl
    implements ResourceRequestData {
        private ResourceKey resourceKey;
        private Object resourceData;

        public ResourceRequestDataImpl(ResourceKey resourceKey, Object resourceData) {
            this.resourceKey = resourceKey;
            this.resourceData = resourceData;
        }

        @Override
        public String getResourceName() {
            return this.resourceKey.getResourceName();
        }

        @Override
        public String getLibraryName() {
            return this.resourceKey.getLibraryName();
        }

        @Override
        public Object getData() {
            return this.resourceData;
        }

        @Override
        public String getResourceKey() {
            return this.resourceKey.toString();
        }

        @Override
        public String getVersion() {
            return null;
        }
    }
}

