/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.rest.HasRestHeaders;
import org.elasticsearch.rest.RestStatus;

public class ElasticsearchException
extends RuntimeException {
    public ElasticsearchException(String msg) {
        super(msg);
    }

    public ElasticsearchException(String msg, Throwable cause) {
        super(msg, cause);
    }

    public RestStatus status() {
        Throwable cause = this.unwrapCause();
        if (cause == this) {
            return RestStatus.INTERNAL_SERVER_ERROR;
        }
        if (cause instanceof ElasticsearchException) {
            return ((ElasticsearchException)cause).status();
        }
        if (cause instanceof IllegalArgumentException) {
            return RestStatus.BAD_REQUEST;
        }
        return RestStatus.INTERNAL_SERVER_ERROR;
    }

    public Throwable unwrapCause() {
        return ExceptionsHelper.unwrapCause(this);
    }

    public String getDetailedMessage() {
        if (this.getCause() != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.toString()).append("; ");
            if (this.getCause() instanceof ElasticsearchException) {
                sb.append(((ElasticsearchException)this.getCause()).getDetailedMessage());
            } else {
                sb.append(this.getCause());
            }
            return sb.toString();
        }
        return super.toString();
    }

    public Throwable getRootCause() {
        Throwable rootCause = this;
        for (Throwable cause = this.getCause(); cause != null && cause != rootCause; cause = cause.getCause()) {
            rootCause = cause;
        }
        return rootCause;
    }

    public Throwable getMostSpecificCause() {
        Throwable rootCause = this.getRootCause();
        return rootCause != null ? rootCause : this;
    }

    public boolean contains(Class exType) {
        if (exType == null) {
            return false;
        }
        if (exType.isInstance(this)) {
            return true;
        }
        Throwable cause = this.getCause();
        if (cause == this) {
            return false;
        }
        if (cause instanceof ElasticsearchException) {
            return ((ElasticsearchException)cause).contains(exType);
        }
        while (cause != null) {
            if (exType.isInstance(cause)) {
                return true;
            }
            if (cause.getCause() == cause) break;
            cause = cause.getCause();
        }
        return false;
    }

    public static class WithRestHeaders
    extends ElasticsearchException
    implements HasRestHeaders {
        private final ImmutableMap<String, List<String>> headers;

        public WithRestHeaders(String msg, Tuple<String, String[]> ... headers) {
            super(msg);
            this.headers = WithRestHeaders.headers(headers);
        }

        public WithRestHeaders(String msg, @Nullable ImmutableMap<String, List<String>> headers) {
            super(msg);
            this.headers = headers != null ? headers : ImmutableMap.of();
        }

        public WithRestHeaders(String msg, Throwable cause, Tuple<String, String[]> ... headers) {
            super(msg, cause);
            this.headers = WithRestHeaders.headers(headers);
        }

        public WithRestHeaders(String msg, Throwable cause, @Nullable ImmutableMap<String, List<String>> headers) {
            super(msg, cause);
            this.headers = headers != null ? headers : ImmutableMap.of();
        }

        public ImmutableMap<String, List<String>> getHeaders() {
            return this.headers;
        }

        protected static Tuple<String, String[]> header(String name, String ... values) {
            return Tuple.tuple(name, values);
        }

        private static ImmutableMap<String, List<String>> headers(Tuple<String, String[]> ... headers) {
            HashMap<String, ArrayList<Object>> map = Maps.newHashMap();
            for (Tuple<String, String[]> header : headers) {
                ArrayList<Object> list = (ArrayList<Object>)map.get(header.v1());
                if (list == null) {
                    list = Lists.newArrayList((Object[])header.v2());
                    map.put(header.v1(), list);
                    continue;
                }
                for (String value : header.v2()) {
                    list.add(value);
                }
            }
            return ImmutableMap.copyOf(map);
        }
    }
}

