/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.TimeoutClusterStateListener;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.unit.TimeValue;

public class ClusterStateObserver {
    protected final ESLogger logger;
    public final ChangePredicate MATCH_ALL_CHANGES_PREDICATE = new EventPredicate(){

        @Override
        public boolean apply(ClusterChangedEvent changedEvent) {
            return changedEvent.previousState().version() != changedEvent.state().version();
        }
    };
    private ClusterService clusterService;
    volatile TimeValue timeOutValue;
    final AtomicReference<ObservedState> lastObservedState;
    final AtomicReference<ObservingContext> observingContext = new AtomicReference<Object>(null);
    volatile long startTime;
    volatile boolean timedOut;
    volatile TimeoutClusterStateListener clusterStateListener = new ObserverClusterStateListener();

    public ClusterStateObserver(ClusterService clusterService, ESLogger logger) {
        this(clusterService, new TimeValue(60000L), logger);
    }

    public ClusterStateObserver(ClusterService clusterService, TimeValue timeout, ESLogger logger) {
        this.timeOutValue = timeout;
        this.clusterService = clusterService;
        this.lastObservedState = new AtomicReference<ObservedState>(new ObservedState(clusterService.state()));
        this.startTime = System.currentTimeMillis();
        this.logger = logger;
    }

    public ClusterState observedState() {
        ObservedState state = this.lastObservedState.get();
        assert (state != null);
        return state.clusterState;
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }

    public void waitForNextChange(Listener listener) {
        this.waitForNextChange(listener, this.MATCH_ALL_CHANGES_PREDICATE);
    }

    public void waitForNextChange(Listener listener, @Nullable TimeValue timeOutValue) {
        this.waitForNextChange(listener, this.MATCH_ALL_CHANGES_PREDICATE, timeOutValue);
    }

    public void waitForNextChange(Listener listener, ChangePredicate changePredicate) {
        this.waitForNextChange(listener, changePredicate, null);
    }

    public void waitForNextChange(Listener listener, ChangePredicate changePredicate, @Nullable TimeValue timeOutValue) {
        long timeoutTimeLeft;
        if (this.observingContext.get() != null) {
            throw new ElasticsearchException("already waiting for a cluster state change");
        }
        if (timeOutValue == null) {
            timeOutValue = this.timeOutValue;
            long timeSinceStart = System.currentTimeMillis() - this.startTime;
            timeoutTimeLeft = timeOutValue.millis() - timeSinceStart;
            if (timeoutTimeLeft <= 0L) {
                this.logger.debug("observer timed out. notifying listener. timeout setting [{}], time since start [{}]", timeOutValue, new TimeValue(timeSinceStart));
                this.timedOut = true;
                this.lastObservedState.set(new ObservedState(this.clusterService.state()));
                listener.onTimeout(timeOutValue);
                return;
            }
        } else {
            this.startTime = System.currentTimeMillis();
            this.timeOutValue = timeOutValue;
            timeoutTimeLeft = timeOutValue.millis();
            this.timedOut = false;
        }
        ObservedState newState = new ObservedState(this.clusterService.state());
        ObservedState lastState = this.lastObservedState.get();
        if (changePredicate.apply(lastState.clusterState, lastState.status, newState.clusterState, newState.status)) {
            this.logger.trace("observer: sampled state accepted by predicate ({})", newState);
            this.lastObservedState.set(newState);
            listener.onNewClusterState(newState.clusterState);
        } else {
            this.logger.trace("observer: sampled state rejected by predicate ({}). adding listener to ClusterService", newState);
            ObservingContext context = new ObservingContext(listener, changePredicate);
            if (!this.observingContext.compareAndSet(null, context)) {
                throw new ElasticsearchException("already waiting for a cluster state change");
            }
            this.clusterService.add(new TimeValue(timeoutTimeLeft), this.clusterStateListener);
        }
    }

    public void reset(ClusterState toState) {
        if (this.observingContext.getAndSet(null) != null) {
            this.clusterService.remove(this.clusterStateListener);
        }
        this.lastObservedState.set(new ObservedState(toState));
    }

    static class ObservedState {
        public final ClusterState clusterState;
        public final ClusterState.ClusterStateStatus status;

        public ObservedState(ClusterState clusterState) {
            this.clusterState = clusterState;
            this.status = clusterState.status();
        }

        public String toString() {
            return "version [" + this.clusterState.version() + "], status [" + (Object)((Object)this.status) + "]";
        }
    }

    static class ObservingContext {
        public final Listener listener;
        public final ChangePredicate changePredicate;

        public ObservingContext(Listener listener, ChangePredicate changePredicate) {
            this.listener = listener;
            this.changePredicate = changePredicate;
        }
    }

    public static abstract class EventPredicate
    implements ChangePredicate {
        @Override
        public boolean apply(ClusterState previousState, ClusterState.ClusterStateStatus previousStatus, ClusterState newState, ClusterState.ClusterStateStatus newStatus) {
            return previousState != newState || previousStatus != newStatus;
        }
    }

    public static abstract class ValidationPredicate
    implements ChangePredicate {
        @Override
        public boolean apply(ClusterState previousState, ClusterState.ClusterStateStatus previousStatus, ClusterState newState, ClusterState.ClusterStateStatus newStatus) {
            if (previousState != newState || previousStatus != newStatus) {
                return this.validate(newState);
            }
            return false;
        }

        protected abstract boolean validate(ClusterState var1);

        @Override
        public boolean apply(ClusterChangedEvent changedEvent) {
            if (changedEvent.previousState().version() != changedEvent.state().version()) {
                return this.validate(changedEvent.state());
            }
            return false;
        }
    }

    public static interface ChangePredicate {
        public boolean apply(ClusterState var1, ClusterState.ClusterStateStatus var2, ClusterState var3, ClusterState.ClusterStateStatus var4);

        public boolean apply(ClusterChangedEvent var1);
    }

    public static interface Listener {
        public void onNewClusterState(ClusterState var1);

        public void onClusterServiceClose();

        public void onTimeout(TimeValue var1);
    }

    class ObserverClusterStateListener
    implements TimeoutClusterStateListener {
        ObserverClusterStateListener() {
        }

        @Override
        public void clusterChanged(ClusterChangedEvent event) {
            ObservingContext context = ClusterStateObserver.this.observingContext.get();
            if (context == null) {
                return;
            }
            if (context.changePredicate.apply(event)) {
                if (ClusterStateObserver.this.observingContext.compareAndSet(context, null)) {
                    ClusterStateObserver.this.clusterService.remove(this);
                    ObservedState state = new ObservedState(event.state());
                    ClusterStateObserver.this.logger.trace("observer: accepting cluster state change ({})", state);
                    ClusterStateObserver.this.lastObservedState.set(state);
                    context.listener.onNewClusterState(state.clusterState);
                } else {
                    ClusterStateObserver.this.logger.trace("observer: predicate approved change but observing context has changed - ignoring (new cluster state version [{}])", event.state().version());
                }
            } else {
                ClusterStateObserver.this.logger.trace("observer: predicate rejected change (new cluster state version [{}])", event.state().version());
            }
        }

        @Override
        public void postAdded() {
            ObservingContext context = ClusterStateObserver.this.observingContext.get();
            if (context == null) {
                return;
            }
            ObservedState newState = new ObservedState(ClusterStateObserver.this.clusterService.state());
            ObservedState lastState = ClusterStateObserver.this.lastObservedState.get();
            if (context.changePredicate.apply(lastState.clusterState, lastState.status, newState.clusterState, newState.status)) {
                if (ClusterStateObserver.this.observingContext.compareAndSet(context, null)) {
                    ClusterStateObserver.this.logger.trace("observer: post adding listener: accepting current cluster state ({})", newState);
                    ClusterStateObserver.this.clusterService.remove(this);
                    ClusterStateObserver.this.lastObservedState.set(newState);
                    context.listener.onNewClusterState(newState.clusterState);
                } else {
                    ClusterStateObserver.this.logger.trace("observer: postAdded - predicate approved state but observing context has changed - ignoring ({})", newState);
                }
            } else {
                ClusterStateObserver.this.logger.trace("observer: postAdded - predicate rejected state ({})", newState);
            }
        }

        @Override
        public void onClose() {
            ObservingContext context = ClusterStateObserver.this.observingContext.getAndSet(null);
            if (context != null) {
                ClusterStateObserver.this.logger.trace("observer: cluster service closed. notifying listener.", new Object[0]);
                ClusterStateObserver.this.clusterService.remove(this);
                context.listener.onClusterServiceClose();
            }
        }

        @Override
        public void onTimeout(TimeValue timeout) {
            ObservingContext context = ClusterStateObserver.this.observingContext.getAndSet(null);
            if (context != null) {
                ClusterStateObserver.this.clusterService.remove(this);
                long timeSinceStart = System.currentTimeMillis() - ClusterStateObserver.this.startTime;
                ClusterStateObserver.this.logger.debug("observer: timeout notification from cluster service. timeout setting [{}], time since start [{}]", ClusterStateObserver.this.timeOutValue, new TimeValue(timeSinceStart));
                ClusterStateObserver.this.lastObservedState.set(new ObservedState(ClusterStateObserver.this.clusterService.state()));
                ClusterStateObserver.this.timedOut = true;
                context.listener.onTimeout(ClusterStateObserver.this.timeOutValue);
            }
        }
    }
}

