/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http;

import org.elasticsearch.common.Preconditions;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.http.HttpServer;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.http.netty.NettyHttpServerTransport;

public class HttpServerModule
extends AbstractModule {
    private final Settings settings;
    private final ESLogger logger;
    private Class<? extends HttpServerTransport> configuredHttpServerTransport;
    private String configuredHttpServerTransportSource;

    public HttpServerModule(Settings settings) {
        this.settings = settings;
        this.logger = Loggers.getLogger(this.getClass(), settings, new String[0]);
    }

    @Override
    protected void configure() {
        if (this.configuredHttpServerTransport != null) {
            this.logger.info("Using [{}] as http transport, overridden by [{}]", this.configuredHttpServerTransport.getName(), this.configuredHttpServerTransportSource);
            this.bind(HttpServerTransport.class).to(this.configuredHttpServerTransport).asEagerSingleton();
        } else {
            Class<NettyHttpServerTransport> defaultHttpServerTransport = NettyHttpServerTransport.class;
            Class<NettyHttpServerTransport> httpServerTransport = this.settings.getAsClass("http.type", defaultHttpServerTransport, "org.elasticsearch.http.", "HttpServerTransport");
            this.bind(HttpServerTransport.class).to(httpServerTransport).asEagerSingleton();
        }
        this.bind(HttpServer.class).asEagerSingleton();
    }

    public void setHttpServerTransport(Class<? extends HttpServerTransport> httpServerTransport, String source) {
        Preconditions.checkNotNull(httpServerTransport, "Configured http server transport may not be null");
        Preconditions.checkNotNull(source, "Plugin, that changes transport may not be null");
        this.configuredHttpServerTransport = httpServerTransport;
        this.configuredHttpServerTransportSource = source;
    }
}

