/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.engine.EngineFactory;
import org.elasticsearch.index.engine.InternalEngineFactory;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShadowIndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.warmer.ShardIndexWarmerService;

public class IndexShardModule
extends AbstractModule {
    public static final String ENGINE_FACTORY = "index.engine.factory";
    private static final Class<? extends EngineFactory> DEFAULT_ENGINE_FACTORY_CLASS = InternalEngineFactory.class;
    private static final String ENGINE_PREFIX = "org.elasticsearch.index.engine.";
    private static final String ENGINE_SUFFIX = "EngineFactory";
    private final ShardId shardId;
    private final Settings settings;
    private final boolean primary;

    public IndexShardModule(ShardId shardId, boolean primary, Settings settings) {
        this.settings = settings;
        this.shardId = shardId;
        this.primary = primary;
    }

    protected boolean useShadowEngine() {
        return !this.primary && IndexMetaData.isIndexUsingShadowReplicas(this.settings);
    }

    @Override
    protected void configure() {
        this.bind(ShardId.class).toInstance(this.shardId);
        if (this.useShadowEngine()) {
            this.bind(IndexShard.class).to(ShadowIndexShard.class).asEagerSingleton();
        } else {
            this.bind(IndexShard.class).asEagerSingleton();
        }
        this.bind(EngineFactory.class).to(this.settings.getAsClass(ENGINE_FACTORY, DEFAULT_ENGINE_FACTORY_CLASS, ENGINE_PREFIX, ENGINE_SUFFIX));
        this.bind(ShardIndexWarmerService.class).asEagerSingleton();
    }
}

