/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.script.AbstractExecutableScript;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.lookup.DocLookup;
import org.elasticsearch.search.lookup.FieldsLookup;
import org.elasticsearch.search.lookup.IndexLookup;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.SourceLookup;

public abstract class AbstractSearchScript
extends AbstractExecutableScript
implements SearchScript {
    private SearchLookup lookup;
    private Scorer scorer;

    protected final DocLookup doc() {
        return this.lookup.doc();
    }

    protected final float score() throws IOException {
        return this.scorer.score();
    }

    protected ScriptDocValues.Strings docFieldStrings(String field) {
        return (ScriptDocValues.Strings)this.doc().get(field);
    }

    protected ScriptDocValues.Doubles docFieldDoubles(String field) {
        return (ScriptDocValues.Doubles)this.doc().get(field);
    }

    protected ScriptDocValues.Longs docFieldLongs(String field) {
        return (ScriptDocValues.Longs)this.doc().get(field);
    }

    protected final SourceLookup source() {
        return this.lookup.source();
    }

    protected final IndexLookup indexLookup() {
        return this.lookup.indexLookup();
    }

    protected final FieldsLookup fields() {
        return this.lookup.fields();
    }

    void setLookup(SearchLookup lookup) {
        this.lookup = lookup;
    }

    @Override
    public void setScorer(Scorer scorer) {
        this.scorer = scorer;
    }

    @Override
    public void setNextReader(AtomicReaderContext context) {
        this.lookup.setNextReader(context);
    }

    @Override
    public void setNextDocId(int doc) {
        this.lookup.setNextDocId(doc);
    }

    @Override
    public void setNextSource(Map<String, Object> source) {
        this.lookup.source().setNextSource(source);
    }

    @Override
    public float runAsFloat() {
        return ((Number)this.run()).floatValue();
    }

    @Override
    public long runAsLong() {
        return ((Number)this.run()).longValue();
    }

    @Override
    public double runAsDouble() {
        return ((Number)this.run()).doubleValue();
    }
}

