/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.action;

import java.io.IOException;
import java.util.concurrent.Callable;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.action.SearchServiceListener;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.fetch.QueryFetchSearchResult;
import org.elasticsearch.search.fetch.ScrollQueryFetchSearchResult;
import org.elasticsearch.search.fetch.ShardFetchRequest;
import org.elasticsearch.search.fetch.ShardFetchSearchRequest;
import org.elasticsearch.search.internal.InternalScrollSearchRequest;
import org.elasticsearch.search.internal.ShardSearchTransportRequest;
import org.elasticsearch.search.query.QuerySearchRequest;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.query.QuerySearchResultProvider;
import org.elasticsearch.search.query.ScrollQuerySearchResult;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.BaseTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public class SearchServiceTransportAction
extends AbstractComponent {
    public static final String FREE_CONTEXT_SCROLL_ACTION_NAME = "indices:data/read/search[free_context/scroll]";
    public static final String FREE_CONTEXT_ACTION_NAME = "indices:data/read/search[free_context]";
    public static final String CLEAR_SCROLL_CONTEXTS_ACTION_NAME = "indices:data/read/search[clear_scroll_contexts]";
    public static final String DFS_ACTION_NAME = "indices:data/read/search[phase/dfs]";
    public static final String QUERY_ACTION_NAME = "indices:data/read/search[phase/query]";
    public static final String QUERY_ID_ACTION_NAME = "indices:data/read/search[phase/query/id]";
    public static final String QUERY_SCROLL_ACTION_NAME = "indices:data/read/search[phase/query/scroll]";
    public static final String QUERY_FETCH_ACTION_NAME = "indices:data/read/search[phase/query+fetch]";
    public static final String QUERY_QUERY_FETCH_ACTION_NAME = "indices:data/read/search[phase/query/query+fetch]";
    public static final String QUERY_FETCH_SCROLL_ACTION_NAME = "indices:data/read/search[phase/query+fetch/scroll]";
    public static final String FETCH_ID_SCROLL_ACTION_NAME = "indices:data/read/search[phase/fetch/id/scroll]";
    public static final String FETCH_ID_ACTION_NAME = "indices:data/read/search[phase/fetch/id]";
    public static final String SCAN_ACTION_NAME = "indices:data/read/search[phase/scan]";
    public static final String SCAN_SCROLL_ACTION_NAME = "indices:data/read/search[phase/scan/scroll]";
    private final ThreadPool threadPool;
    private final TransportService transportService;
    private final ClusterService clusterService;
    private final SearchService searchService;
    private final FreeContextResponseHandler freeContextResponseHandler = new FreeContextResponseHandler(new ActionListener<Boolean>(){

        @Override
        public void onResponse(Boolean aBoolean) {
        }

        @Override
        public void onFailure(Throwable exp) {
            SearchServiceTransportAction.this.logger.warn("Failed to send release search context", exp, new Object[0]);
        }
    });

    @Inject
    public SearchServiceTransportAction(Settings settings, ThreadPool threadPool, TransportService transportService, ClusterService clusterService, SearchService searchService) {
        super(settings);
        this.threadPool = threadPool;
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.searchService = searchService;
        transportService.registerHandler(FREE_CONTEXT_SCROLL_ACTION_NAME, new ScrollFreeContextTransportHandler());
        transportService.registerHandler(FREE_CONTEXT_ACTION_NAME, new SearchFreeContextTransportHandler());
        transportService.registerHandler(CLEAR_SCROLL_CONTEXTS_ACTION_NAME, new ClearScrollContextsTransportHandler());
        transportService.registerHandler(DFS_ACTION_NAME, new SearchDfsTransportHandler());
        transportService.registerHandler(QUERY_ACTION_NAME, new SearchQueryTransportHandler());
        transportService.registerHandler(QUERY_ID_ACTION_NAME, new SearchQueryByIdTransportHandler());
        transportService.registerHandler(QUERY_SCROLL_ACTION_NAME, new SearchQueryScrollTransportHandler());
        transportService.registerHandler(QUERY_FETCH_ACTION_NAME, new SearchQueryFetchTransportHandler());
        transportService.registerHandler(QUERY_QUERY_FETCH_ACTION_NAME, new SearchQueryQueryFetchTransportHandler());
        transportService.registerHandler(QUERY_FETCH_SCROLL_ACTION_NAME, new SearchQueryFetchScrollTransportHandler());
        transportService.registerHandler(FETCH_ID_SCROLL_ACTION_NAME, new ScrollFetchByIdTransportHandler());
        transportService.registerHandler(FETCH_ID_ACTION_NAME, new SearchFetchByIdTransportHandler());
        transportService.registerHandler(SCAN_ACTION_NAME, new SearchScanTransportHandler());
        transportService.registerHandler(SCAN_SCROLL_ACTION_NAME, new SearchScanScrollTransportHandler());
    }

    public void sendFreeContext(DiscoveryNode node, long contextId, SearchRequest request) {
        if (this.clusterService.state().nodes().localNodeId().equals(node.id())) {
            this.searchService.freeContext(contextId);
        } else {
            this.transportService.sendRequest(node, FREE_CONTEXT_ACTION_NAME, new SearchFreeContextRequest(request, contextId), this.freeContextResponseHandler);
        }
    }

    public void sendFreeContext(DiscoveryNode node, long contextId, ClearScrollRequest request, ActionListener<Boolean> actionListener) {
        if (this.clusterService.state().nodes().localNodeId().equals(node.id())) {
            boolean freed = this.searchService.freeContext(contextId);
            actionListener.onResponse(freed);
        } else if (node.getVersion().onOrAfter(Version.V_1_4_0_Beta1)) {
            this.transportService.sendRequest(node, FREE_CONTEXT_SCROLL_ACTION_NAME, new ScrollFreeContextRequest(request, contextId), new FreeContextResponseHandler(actionListener));
        } else {
            this.transportService.sendRequest(node, FREE_CONTEXT_ACTION_NAME, new ScrollFreeContextRequest(request, contextId), new FreeContextResponseHandler(actionListener));
        }
    }

    public void sendClearAllScrollContexts(DiscoveryNode node, ClearScrollRequest request, final ActionListener<Boolean> actionListener) {
        if (this.clusterService.state().nodes().localNodeId().equals(node.id())) {
            this.searchService.freeAllScrollContexts();
            actionListener.onResponse(true);
        } else {
            this.transportService.sendRequest(node, CLEAR_SCROLL_CONTEXTS_ACTION_NAME, new ClearScrollContextsRequest(request), new TransportResponseHandler<TransportResponse>(){

                @Override
                public TransportResponse newInstance() {
                    return TransportResponse.Empty.INSTANCE;
                }

                @Override
                public void handleResponse(TransportResponse response) {
                    actionListener.onResponse(true);
                }

                @Override
                public void handleException(TransportException exp) {
                    actionListener.onFailure(exp);
                }

                @Override
                public String executor() {
                    return "same";
                }
            });
        }
    }

    public void sendExecuteDfs(DiscoveryNode node, final ShardSearchTransportRequest request, final SearchServiceListener<DfsSearchResult> listener) {
        if (this.clusterService.state().nodes().localNodeId().equals(node.id())) {
            this.execute(new Callable<DfsSearchResult>(){

                @Override
                public DfsSearchResult call() throws Exception {
                    return SearchServiceTransportAction.this.searchService.executeDfsPhase(request);
                }
            }, listener);
        } else {
            this.transportService.sendRequest(node, DFS_ACTION_NAME, request, new BaseTransportResponseHandler<DfsSearchResult>(){

                @Override
                public DfsSearchResult newInstance() {
                    return new DfsSearchResult();
                }

                @Override
                public void handleResponse(DfsSearchResult response) {
                    listener.onResult(response);
                }

                @Override
                public void handleException(TransportException exp) {
                    listener.onFailure(exp);
                }

                @Override
                public String executor() {
                    return "same";
                }
            });
        }
    }

    public void sendExecuteQuery(DiscoveryNode node, final ShardSearchTransportRequest request, final SearchServiceListener<QuerySearchResultProvider> listener) {
        if (this.clusterService.state().nodes().localNodeId().equals(node.id())) {
            this.execute(new Callable<QuerySearchResultProvider>(){

                @Override
                public QuerySearchResultProvider call() throws Exception {
                    return SearchServiceTransportAction.this.searchService.executeQueryPhase(request);
                }
            }, listener);
        } else {
            this.transportService.sendRequest(node, QUERY_ACTION_NAME, request, new BaseTransportResponseHandler<QuerySearchResultProvider>(){

                @Override
                public QuerySearchResult newInstance() {
                    return new QuerySearchResult();
                }

                @Override
                public void handleResponse(QuerySearchResultProvider response) {
                    listener.onResult(response);
                }

                @Override
                public void handleException(TransportException exp) {
                    listener.onFailure(exp);
                }

                @Override
                public String executor() {
                    return "same";
                }
            });
        }
    }

    public void sendExecuteQuery(DiscoveryNode node, final QuerySearchRequest request, final SearchServiceListener<QuerySearchResult> listener) {
        if (this.clusterService.state().nodes().localNodeId().equals(node.id())) {
            this.execute(new Callable<QuerySearchResult>(){

                @Override
                public QuerySearchResult call() throws Exception {
                    return SearchServiceTransportAction.this.searchService.executeQueryPhase(request);
                }
            }, listener);
        } else {
            this.transportService.sendRequest(node, QUERY_ID_ACTION_NAME, request, new BaseTransportResponseHandler<QuerySearchResult>(){

                @Override
                public QuerySearchResult newInstance() {
                    return new QuerySearchResult();
                }

                @Override
                public void handleResponse(QuerySearchResult response) {
                    listener.onResult(response);
                }

                @Override
                public void handleException(TransportException exp) {
                    listener.onFailure(exp);
                }

                @Override
                public String executor() {
                    return "same";
                }
            });
        }
    }

    public void sendExecuteQuery(DiscoveryNode node, final InternalScrollSearchRequest request, final SearchServiceListener<QuerySearchResult> listener) {
        if (this.clusterService.state().nodes().localNodeId().equals(node.id())) {
            this.execute(new Callable<QuerySearchResult>(){

                @Override
                public QuerySearchResult call() throws Exception {
                    return SearchServiceTransportAction.this.searchService.executeQueryPhase(request).queryResult();
                }
            }, listener);
        } else {
            this.transportService.sendRequest(node, QUERY_SCROLL_ACTION_NAME, request, new BaseTransportResponseHandler<ScrollQuerySearchResult>(){

                @Override
                public ScrollQuerySearchResult newInstance() {
                    return new ScrollQuerySearchResult();
                }

                @Override
                public void handleResponse(ScrollQuerySearchResult response) {
                    listener.onResult(response.queryResult());
                }

                @Override
                public void handleException(TransportException exp) {
                    listener.onFailure(exp);
                }

                @Override
                public String executor() {
                    return "same";
                }
            });
        }
    }

    public void sendExecuteFetch(DiscoveryNode node, final ShardSearchTransportRequest request, final SearchServiceListener<QueryFetchSearchResult> listener) {
        if (this.clusterService.state().nodes().localNodeId().equals(node.id())) {
            this.execute(new Callable<QueryFetchSearchResult>(){

                @Override
                public QueryFetchSearchResult call() throws Exception {
                    return SearchServiceTransportAction.this.searchService.executeFetchPhase(request);
                }
            }, listener);
        } else {
            this.transportService.sendRequest(node, QUERY_FETCH_ACTION_NAME, request, new BaseTransportResponseHandler<QueryFetchSearchResult>(){

                @Override
                public QueryFetchSearchResult newInstance() {
                    return new QueryFetchSearchResult();
                }

                @Override
                public void handleResponse(QueryFetchSearchResult response) {
                    listener.onResult(response);
                }

                @Override
                public void handleException(TransportException exp) {
                    listener.onFailure(exp);
                }

                @Override
                public String executor() {
                    return "same";
                }
            });
        }
    }

    public void sendExecuteFetch(DiscoveryNode node, final QuerySearchRequest request, final SearchServiceListener<QueryFetchSearchResult> listener) {
        if (this.clusterService.state().nodes().localNodeId().equals(node.id())) {
            this.execute(new Callable<QueryFetchSearchResult>(){

                @Override
                public QueryFetchSearchResult call() throws Exception {
                    return SearchServiceTransportAction.this.searchService.executeFetchPhase(request);
                }
            }, listener);
        } else {
            this.transportService.sendRequest(node, QUERY_QUERY_FETCH_ACTION_NAME, request, new BaseTransportResponseHandler<QueryFetchSearchResult>(){

                @Override
                public QueryFetchSearchResult newInstance() {
                    return new QueryFetchSearchResult();
                }

                @Override
                public void handleResponse(QueryFetchSearchResult response) {
                    listener.onResult(response);
                }

                @Override
                public void handleException(TransportException exp) {
                    listener.onFailure(exp);
                }

                @Override
                public String executor() {
                    return "same";
                }
            });
        }
    }

    public void sendExecuteFetch(DiscoveryNode node, final InternalScrollSearchRequest request, final SearchServiceListener<QueryFetchSearchResult> listener) {
        if (this.clusterService.state().nodes().localNodeId().equals(node.id())) {
            this.execute(new Callable<QueryFetchSearchResult>(){

                @Override
                public QueryFetchSearchResult call() throws Exception {
                    return SearchServiceTransportAction.this.searchService.executeFetchPhase(request).result();
                }
            }, listener);
        } else {
            this.transportService.sendRequest(node, QUERY_FETCH_SCROLL_ACTION_NAME, request, new BaseTransportResponseHandler<ScrollQueryFetchSearchResult>(){

                @Override
                public ScrollQueryFetchSearchResult newInstance() {
                    return new ScrollQueryFetchSearchResult();
                }

                @Override
                public void handleResponse(ScrollQueryFetchSearchResult response) {
                    listener.onResult(response.result());
                }

                @Override
                public void handleException(TransportException exp) {
                    listener.onFailure(exp);
                }

                @Override
                public String executor() {
                    return "same";
                }
            });
        }
    }

    public void sendExecuteFetch(DiscoveryNode node, ShardFetchSearchRequest request, SearchServiceListener<FetchSearchResult> listener) {
        this.sendExecuteFetch(node, FETCH_ID_ACTION_NAME, request, listener);
    }

    public void sendExecuteFetchScroll(DiscoveryNode node, ShardFetchRequest request, SearchServiceListener<FetchSearchResult> listener) {
        String action = node.getVersion().onOrAfter(Version.V_1_4_0_Beta1) ? FETCH_ID_SCROLL_ACTION_NAME : FETCH_ID_ACTION_NAME;
        this.sendExecuteFetch(node, action, request, listener);
    }

    private void sendExecuteFetch(DiscoveryNode node, String action, final ShardFetchRequest request, final SearchServiceListener<FetchSearchResult> listener) {
        if (this.clusterService.state().nodes().localNodeId().equals(node.id())) {
            this.execute(new Callable<FetchSearchResult>(){

                @Override
                public FetchSearchResult call() throws Exception {
                    return SearchServiceTransportAction.this.searchService.executeFetchPhase(request);
                }
            }, listener);
        } else {
            this.transportService.sendRequest(node, action, request, new BaseTransportResponseHandler<FetchSearchResult>(){

                @Override
                public FetchSearchResult newInstance() {
                    return new FetchSearchResult();
                }

                @Override
                public void handleResponse(FetchSearchResult response) {
                    listener.onResult(response);
                }

                @Override
                public void handleException(TransportException exp) {
                    listener.onFailure(exp);
                }

                @Override
                public String executor() {
                    return "same";
                }
            });
        }
    }

    public void sendExecuteScan(DiscoveryNode node, final ShardSearchTransportRequest request, final SearchServiceListener<QuerySearchResult> listener) {
        if (this.clusterService.state().nodes().localNodeId().equals(node.id())) {
            this.execute(new Callable<QuerySearchResult>(){

                @Override
                public QuerySearchResult call() throws Exception {
                    return SearchServiceTransportAction.this.searchService.executeScan(request);
                }
            }, listener);
        } else {
            this.transportService.sendRequest(node, SCAN_ACTION_NAME, request, new BaseTransportResponseHandler<QuerySearchResult>(){

                @Override
                public QuerySearchResult newInstance() {
                    return new QuerySearchResult();
                }

                @Override
                public void handleResponse(QuerySearchResult response) {
                    listener.onResult(response);
                }

                @Override
                public void handleException(TransportException exp) {
                    listener.onFailure(exp);
                }

                @Override
                public String executor() {
                    return "same";
                }
            });
        }
    }

    public void sendExecuteScan(DiscoveryNode node, final InternalScrollSearchRequest request, final SearchServiceListener<QueryFetchSearchResult> listener) {
        if (this.clusterService.state().nodes().localNodeId().equals(node.id())) {
            this.execute(new Callable<QueryFetchSearchResult>(){

                @Override
                public QueryFetchSearchResult call() throws Exception {
                    return SearchServiceTransportAction.this.searchService.executeScan(request).result();
                }
            }, listener);
        } else {
            this.transportService.sendRequest(node, SCAN_SCROLL_ACTION_NAME, request, new BaseTransportResponseHandler<ScrollQueryFetchSearchResult>(){

                @Override
                public ScrollQueryFetchSearchResult newInstance() {
                    return new ScrollQueryFetchSearchResult();
                }

                @Override
                public void handleResponse(ScrollQueryFetchSearchResult response) {
                    listener.onResult(response.result());
                }

                @Override
                public void handleException(TransportException exp) {
                    listener.onFailure(exp);
                }

                @Override
                public String executor() {
                    return "same";
                }
            });
        }
    }

    private <T> void execute(final Callable<? extends T> callable, final SearchServiceListener<T> listener) {
        try {
            this.threadPool.executor("search").execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object result = null;
                    Throwable error = null;
                    try {
                        result = callable.call();
                    }
                    catch (Throwable t) {
                        error = t;
                    }
                    finally {
                        if (result == null) {
                            assert (error != null);
                            listener.onFailure(error);
                        } else {
                            assert (error == null) : error;
                            listener.onResult(result);
                        }
                    }
                }
            });
        }
        catch (Throwable t) {
            listener.onFailure(t);
        }
    }

    private class SearchScanScrollTransportHandler
    extends BaseTransportRequestHandler<InternalScrollSearchRequest> {
        private SearchScanScrollTransportHandler() {
        }

        @Override
        public InternalScrollSearchRequest newInstance() {
            return new InternalScrollSearchRequest();
        }

        @Override
        public void messageReceived(InternalScrollSearchRequest request, TransportChannel channel) throws Exception {
            ScrollQueryFetchSearchResult result = SearchServiceTransportAction.this.searchService.executeScan(request);
            channel.sendResponse(result);
        }

        @Override
        public String executor() {
            return "search";
        }
    }

    private class SearchScanTransportHandler
    extends BaseTransportRequestHandler<ShardSearchTransportRequest> {
        private SearchScanTransportHandler() {
        }

        @Override
        public ShardSearchTransportRequest newInstance() {
            return new ShardSearchTransportRequest();
        }

        @Override
        public void messageReceived(ShardSearchTransportRequest request, TransportChannel channel) throws Exception {
            QuerySearchResult result = SearchServiceTransportAction.this.searchService.executeScan(request);
            channel.sendResponse(result);
        }

        @Override
        public String executor() {
            return "search";
        }
    }

    private class SearchQueryFetchScrollTransportHandler
    extends BaseTransportRequestHandler<InternalScrollSearchRequest> {
        private SearchQueryFetchScrollTransportHandler() {
        }

        @Override
        public InternalScrollSearchRequest newInstance() {
            return new InternalScrollSearchRequest();
        }

        @Override
        public void messageReceived(InternalScrollSearchRequest request, TransportChannel channel) throws Exception {
            ScrollQueryFetchSearchResult result = SearchServiceTransportAction.this.searchService.executeFetchPhase(request);
            channel.sendResponse(result);
        }

        @Override
        public String executor() {
            return "search";
        }
    }

    private class SearchFetchByIdTransportHandler
    extends FetchByIdTransportHandler<ShardFetchSearchRequest> {
        private SearchFetchByIdTransportHandler() {
        }

        @Override
        public ShardFetchSearchRequest newInstance() {
            return new ShardFetchSearchRequest();
        }
    }

    private class ScrollFetchByIdTransportHandler
    extends FetchByIdTransportHandler<ShardFetchRequest> {
        private ScrollFetchByIdTransportHandler() {
        }

        @Override
        public ShardFetchRequest newInstance() {
            return new ShardFetchRequest();
        }
    }

    private abstract class FetchByIdTransportHandler<Request extends ShardFetchRequest>
    extends BaseTransportRequestHandler<Request> {
        private FetchByIdTransportHandler() {
        }

        @Override
        public abstract Request newInstance();

        @Override
        public void messageReceived(Request request, TransportChannel channel) throws Exception {
            FetchSearchResult result = SearchServiceTransportAction.this.searchService.executeFetchPhase((ShardFetchRequest)request);
            channel.sendResponse(result);
        }

        @Override
        public String executor() {
            return "search";
        }
    }

    private class SearchQueryQueryFetchTransportHandler
    extends BaseTransportRequestHandler<QuerySearchRequest> {
        private SearchQueryQueryFetchTransportHandler() {
        }

        @Override
        public QuerySearchRequest newInstance() {
            return new QuerySearchRequest();
        }

        @Override
        public void messageReceived(QuerySearchRequest request, TransportChannel channel) throws Exception {
            QueryFetchSearchResult result = SearchServiceTransportAction.this.searchService.executeFetchPhase(request);
            channel.sendResponse(result);
        }

        @Override
        public String executor() {
            return "search";
        }
    }

    private class SearchQueryFetchTransportHandler
    extends BaseTransportRequestHandler<ShardSearchTransportRequest> {
        private SearchQueryFetchTransportHandler() {
        }

        @Override
        public ShardSearchTransportRequest newInstance() {
            return new ShardSearchTransportRequest();
        }

        @Override
        public void messageReceived(ShardSearchTransportRequest request, TransportChannel channel) throws Exception {
            QueryFetchSearchResult result = SearchServiceTransportAction.this.searchService.executeFetchPhase(request);
            channel.sendResponse(result);
        }

        @Override
        public String executor() {
            return "search";
        }
    }

    private class SearchQueryScrollTransportHandler
    extends BaseTransportRequestHandler<InternalScrollSearchRequest> {
        private SearchQueryScrollTransportHandler() {
        }

        @Override
        public InternalScrollSearchRequest newInstance() {
            return new InternalScrollSearchRequest();
        }

        @Override
        public void messageReceived(InternalScrollSearchRequest request, TransportChannel channel) throws Exception {
            ScrollQuerySearchResult result = SearchServiceTransportAction.this.searchService.executeQueryPhase(request);
            channel.sendResponse(result);
        }

        @Override
        public String executor() {
            return "search";
        }
    }

    private class SearchQueryByIdTransportHandler
    extends BaseTransportRequestHandler<QuerySearchRequest> {
        private SearchQueryByIdTransportHandler() {
        }

        @Override
        public QuerySearchRequest newInstance() {
            return new QuerySearchRequest();
        }

        @Override
        public void messageReceived(QuerySearchRequest request, TransportChannel channel) throws Exception {
            QuerySearchResult result = SearchServiceTransportAction.this.searchService.executeQueryPhase(request);
            channel.sendResponse(result);
        }

        @Override
        public String executor() {
            return "search";
        }
    }

    private class SearchQueryTransportHandler
    extends BaseTransportRequestHandler<ShardSearchTransportRequest> {
        private SearchQueryTransportHandler() {
        }

        @Override
        public ShardSearchTransportRequest newInstance() {
            return new ShardSearchTransportRequest();
        }

        @Override
        public void messageReceived(ShardSearchTransportRequest request, TransportChannel channel) throws Exception {
            QuerySearchResultProvider result = SearchServiceTransportAction.this.searchService.executeQueryPhase(request);
            channel.sendResponse(result);
        }

        @Override
        public String executor() {
            return "search";
        }
    }

    private class SearchDfsTransportHandler
    extends BaseTransportRequestHandler<ShardSearchTransportRequest> {
        private SearchDfsTransportHandler() {
        }

        @Override
        public ShardSearchTransportRequest newInstance() {
            return new ShardSearchTransportRequest();
        }

        @Override
        public void messageReceived(ShardSearchTransportRequest request, TransportChannel channel) throws Exception {
            DfsSearchResult result = SearchServiceTransportAction.this.searchService.executeDfsPhase(request);
            channel.sendResponse(result);
        }

        @Override
        public String executor() {
            return "search";
        }
    }

    class ClearScrollContextsTransportHandler
    extends BaseTransportRequestHandler<ClearScrollContextsRequest> {
        ClearScrollContextsTransportHandler() {
        }

        @Override
        public ClearScrollContextsRequest newInstance() {
            return new ClearScrollContextsRequest();
        }

        @Override
        public void messageReceived(ClearScrollContextsRequest request, TransportChannel channel) throws Exception {
            SearchServiceTransportAction.this.searchService.freeAllScrollContexts();
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }

        @Override
        public String executor() {
            return "same";
        }
    }

    static class ClearScrollContextsRequest
    extends TransportRequest {
        ClearScrollContextsRequest() {
        }

        ClearScrollContextsRequest(TransportRequest request) {
            super(request);
        }
    }

    class SearchFreeContextTransportHandler
    extends BaseFreeContextTransportHandler<SearchFreeContextRequest> {
        SearchFreeContextTransportHandler() {
        }

        @Override
        public SearchFreeContextRequest newInstance() {
            return new SearchFreeContextRequest();
        }
    }

    class ScrollFreeContextTransportHandler
    extends BaseFreeContextTransportHandler<ScrollFreeContextRequest> {
        ScrollFreeContextTransportHandler() {
        }

        @Override
        public ScrollFreeContextRequest newInstance() {
            return new ScrollFreeContextRequest();
        }
    }

    private abstract class BaseFreeContextTransportHandler<FreeContextRequest extends ScrollFreeContextRequest>
    extends BaseTransportRequestHandler<FreeContextRequest> {
        private BaseFreeContextTransportHandler() {
        }

        @Override
        public abstract FreeContextRequest newInstance();

        @Override
        public void messageReceived(FreeContextRequest request, TransportChannel channel) throws Exception {
            boolean freed = SearchServiceTransportAction.this.searchService.freeContext(((ScrollFreeContextRequest)request).id());
            channel.sendResponse(new SearchFreeContextResponse(freed));
        }

        @Override
        public String executor() {
            return "same";
        }
    }

    static class SearchFreeContextResponse
    extends TransportResponse {
        private boolean freed;

        SearchFreeContextResponse() {
        }

        SearchFreeContextResponse(boolean freed) {
            this.freed = freed;
        }

        public boolean isFreed() {
            return this.freed;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.freed = in.getVersion().onOrAfter(Version.V_1_2_0) ? in.readBoolean() : true;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            if (out.getVersion().onOrAfter(Version.V_1_2_0)) {
                out.writeBoolean(this.freed);
            }
        }
    }

    static class SearchFreeContextRequest
    extends ScrollFreeContextRequest
    implements IndicesRequest {
        private OriginalIndices originalIndices;

        SearchFreeContextRequest() {
        }

        SearchFreeContextRequest(SearchRequest request, long id) {
            super(request, id);
            this.originalIndices = new OriginalIndices(request);
        }

        @Override
        public String[] indices() {
            if (this.originalIndices == null) {
                return null;
            }
            return this.originalIndices.indices();
        }

        @Override
        public IndicesOptions indicesOptions() {
            if (this.originalIndices == null) {
                return null;
            }
            return this.originalIndices.indicesOptions();
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.originalIndices = OriginalIndices.readOriginalIndices(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            OriginalIndices.writeOriginalIndices(this.originalIndices, out);
        }
    }

    static class ScrollFreeContextRequest
    extends TransportRequest {
        private long id;

        ScrollFreeContextRequest() {
        }

        ScrollFreeContextRequest(ClearScrollRequest request, long id) {
            this((TransportRequest)request, id);
        }

        private ScrollFreeContextRequest(TransportRequest request, long id) {
            super(request);
            this.id = id;
        }

        public long id() {
            return this.id;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.id = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeLong(this.id);
        }
    }

    static final class FreeContextResponseHandler
    implements TransportResponseHandler<SearchFreeContextResponse> {
        private final ActionListener<Boolean> listener;

        FreeContextResponseHandler(ActionListener<Boolean> listener) {
            this.listener = listener;
        }

        @Override
        public SearchFreeContextResponse newInstance() {
            return new SearchFreeContextResponse();
        }

        @Override
        public void handleResponse(SearchFreeContextResponse response) {
            this.listener.onResponse(response.freed);
        }

        @Override
        public void handleException(TransportException exp) {
            this.listener.onFailure(exp);
        }

        @Override
        public String executor() {
            return "same";
        }
    }
}

