/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.base.Predicate;
import org.elasticsearch.common.collect.Iterables;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.BucketCollector;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.DeferringBucketCollector;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.query.QueryPhaseExecutionException;

public abstract class Aggregator
extends BucketCollector
implements Releasable {
    private static final Predicate<Aggregator> COLLECTABLE_AGGREGATOR = new Predicate<Aggregator>(){

        @Override
        public boolean apply(Aggregator aggregator) {
            return aggregator.shouldCollect();
        }
    };
    public static final ParseField COLLECT_MODE = new ParseField("collect_mode", new String[0]);
    static final Scorer unavailableScorer = new Scorer(null){
        private final String MSG = "A limitation of the " + SubAggCollectionMode.access$000(SubAggCollectionMode.BREADTH_FIRST).getPreferredName() + " collection mode is that scores cannot be buffered along with document IDs";

        public float score() throws IOException {
            throw new ElasticsearchParseException(this.MSG);
        }

        public int freq() throws IOException {
            throw new ElasticsearchParseException(this.MSG);
        }

        public int advance(int arg0) throws IOException {
            throw new ElasticsearchParseException(this.MSG);
        }

        public long cost() {
            throw new ElasticsearchParseException(this.MSG);
        }

        public int docID() {
            throw new ElasticsearchParseException(this.MSG);
        }

        public int nextDoc() throws IOException {
            throw new ElasticsearchParseException(this.MSG);
        }
    };
    protected final String name;
    protected final Aggregator parent;
    protected final AggregationContext context;
    protected final BigArrays bigArrays;
    protected final int depth;
    protected final long estimatedBucketCount;
    protected final BucketAggregationMode bucketAggregationMode;
    protected final AggregatorFactories factories;
    protected final Aggregator[] subAggregators;
    protected BucketCollector collectableSubAggregators;
    private Map<String, Aggregator> subAggregatorbyName;
    private DeferringBucketCollector recordingWrapper;

    public static boolean hasParentBucketAggregator(Aggregator parent) {
        if (parent == null) {
            return false;
        }
        if (parent.bucketAggregationMode() == BucketAggregationMode.PER_BUCKET) {
            return true;
        }
        return Aggregator.hasParentBucketAggregator(parent.parent());
    }

    protected Aggregator(String name, BucketAggregationMode bucketAggregationMode, AggregatorFactories factories, long estimatedBucketsCount, AggregationContext context, Aggregator parent) {
        this.name = name;
        this.parent = parent;
        this.estimatedBucketCount = estimatedBucketsCount;
        this.context = context;
        this.bigArrays = context.bigArrays();
        this.depth = parent == null ? 0 : 1 + parent.depth();
        this.bucketAggregationMode = bucketAggregationMode;
        assert (factories != null) : "sub-factories provided to BucketAggregator must not be null, use AggragatorFactories.EMPTY instead";
        this.factories = factories;
        this.subAggregators = factories.createSubAggregators(this, estimatedBucketsCount);
        context.searchContext().addReleasable(this, SearchContext.Lifetime.PHASE);
        this.collectableSubAggregators = new BucketCollector(){

            void badState() {
                throw new QueryPhaseExecutionException(Aggregator.this.context.searchContext(), "preCollection not called on new Aggregator before use", null);
            }

            @Override
            public void setNextReader(AtomicReaderContext reader) {
                this.badState();
            }

            @Override
            public void postCollection() throws IOException {
                this.badState();
            }

            @Override
            public void collect(int docId, long bucketOrdinal) throws IOException {
                this.badState();
            }

            @Override
            public void gatherAnalysis(BucketCollector.BucketAnalysisCollector results, long bucketOrdinal) {
                this.badState();
            }
        };
    }

    protected void preCollection() {
        Iterable<Aggregator> collectables = Iterables.filter(Arrays.asList(this.subAggregators), COLLECTABLE_AGGREGATOR);
        ArrayList<Aggregator> nextPassCollectors = new ArrayList<Aggregator>();
        ArrayList<BucketCollector> thisPassCollectors = new ArrayList<BucketCollector>();
        for (Aggregator aggregator : collectables) {
            if (this.shouldDefer(aggregator)) {
                nextPassCollectors.add(aggregator);
                continue;
            }
            thisPassCollectors.add(aggregator);
        }
        if (nextPassCollectors.size() > 0) {
            BucketCollector deferreds = BucketCollector.wrap(nextPassCollectors);
            this.recordingWrapper = new DeferringBucketCollector(deferreds, this.context);
            this.context.registerReaderContextAware(this.recordingWrapper);
            thisPassCollectors.add(this.recordingWrapper);
        }
        this.collectableSubAggregators = BucketCollector.wrap(thisPassCollectors);
    }

    protected boolean shouldDefer(Aggregator aggregator) {
        return false;
    }

    protected void runDeferredCollections(long ... bucketOrds) {
        if (this.recordingWrapper != null) {
            this.context.setScorer(unavailableScorer);
            this.recordingWrapper.prepareSelectedBuckets(bucketOrds);
        }
    }

    public String name() {
        return this.name;
    }

    public final long estimatedBucketCount() {
        return this.estimatedBucketCount;
    }

    public final int depth() {
        return this.depth;
    }

    public Aggregator parent() {
        return this.parent;
    }

    public Aggregator[] subAggregators() {
        return this.subAggregators;
    }

    public Aggregator subAggregator(String aggName) {
        if (this.subAggregatorbyName == null) {
            this.subAggregatorbyName = new HashMap<String, Aggregator>(this.subAggregators.length);
            for (int i = 0; i < this.subAggregators.length; ++i) {
                this.subAggregatorbyName.put(this.subAggregators[i].name, this.subAggregators[i]);
            }
        }
        return this.subAggregatorbyName.get(aggName);
    }

    public AggregationContext context() {
        return this.context;
    }

    public BucketAggregationMode bucketAggregationMode() {
        return this.bucketAggregationMode;
    }

    public abstract boolean shouldCollect();

    @Override
    public final void postCollection() throws IOException {
        this.doPostCollection();
        this.collectableSubAggregators.postCollection();
    }

    @Override
    public void close() {
        try (DeferringBucketCollector _ = this.recordingWrapper;){
            this.doClose();
        }
    }

    protected void doClose() {
    }

    protected void doPostCollection() throws IOException {
    }

    public abstract InternalAggregation buildAggregation(long var1);

    @Override
    public void gatherAnalysis(BucketCollector.BucketAnalysisCollector results, long bucketOrdinal) {
        results.add(this.buildAggregation(bucketOrdinal));
    }

    public abstract InternalAggregation buildEmptyAggregation();

    protected final InternalAggregations buildEmptySubAggregations() {
        ArrayList<InternalAggregation> aggs = new ArrayList<InternalAggregation>();
        for (Aggregator aggregator : this.subAggregators) {
            aggs.add(aggregator.buildEmptyAggregation());
        }
        return new InternalAggregations(aggs);
    }

    public static interface Parser {
        public String type();

        public AggregatorFactory parse(String var1, XContentParser var2, SearchContext var3) throws IOException;
    }

    public static enum SubAggCollectionMode {
        DEPTH_FIRST(new ParseField("depth_first", new String[0])),
        BREADTH_FIRST(new ParseField("breadth_first", new String[0]));

        private final ParseField parseField;

        private SubAggCollectionMode(ParseField parseField) {
            this.parseField = parseField;
        }

        public ParseField parseField() {
            return this.parseField;
        }

        public static SubAggCollectionMode parse(String value) {
            return SubAggCollectionMode.parse(value, ParseField.EMPTY_FLAGS);
        }

        public static SubAggCollectionMode parse(String value, EnumSet<ParseField.Flag> flags) {
            SubAggCollectionMode[] modes;
            for (SubAggCollectionMode mode : modes = SubAggCollectionMode.values()) {
                if (!mode.parseField.match(value, flags)) continue;
                return mode;
            }
            throw new ElasticsearchParseException("No " + COLLECT_MODE.getPreferredName() + " found for value [" + value + "]");
        }

        static /* synthetic */ ParseField access$000(SubAggCollectionMode x0) {
            return x0.parseField;
        }
    }

    public static enum BucketAggregationMode {
        PER_BUCKET,
        MULTI_BUCKETS;

    }
}

