/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.filters;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.Bits;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.lucene.docset.DocIdSets;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.elasticsearch.search.aggregations.bucket.filters.InternalFilters;
import org.elasticsearch.search.aggregations.support.AggregationContext;

public class FiltersAggregator
extends BucketsAggregator {
    private final KeyedFilter[] filters;
    private final Bits[] bits;
    private boolean keyed;

    public FiltersAggregator(String name, AggregatorFactories factories, List<KeyedFilter> filters, boolean keyed, AggregationContext aggregationContext, Aggregator parent) {
        super(name, Aggregator.BucketAggregationMode.MULTI_BUCKETS, factories, (long)filters.size() * (parent == null ? 1L : parent.estimatedBucketCount()), aggregationContext, parent);
        this.keyed = keyed;
        this.filters = filters.toArray(new KeyedFilter[filters.size()]);
        this.bits = new Bits[this.filters.length];
    }

    @Override
    public boolean shouldCollect() {
        return true;
    }

    @Override
    public void setNextReader(AtomicReaderContext reader) {
        try {
            for (int i = 0; i < this.filters.length; ++i) {
                this.bits[i] = DocIdSets.toSafeBits(reader.reader(), this.filters[i].filter.getDocIdSet(reader, null));
            }
        }
        catch (IOException ioe) {
            throw new AggregationExecutionException("Failed to aggregate filter aggregator [" + this.name + "]", ioe);
        }
    }

    @Override
    public void collect(int doc, long owningBucketOrdinal) throws IOException {
        for (int i = 0; i < this.bits.length; ++i) {
            if (!this.bits[i].get(doc)) continue;
            this.collectBucket(doc, this.bucketOrd(owningBucketOrdinal, i));
        }
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        ArrayList<InternalFilters.Bucket> buckets = Lists.newArrayListWithCapacity(this.filters.length);
        for (int i = 0; i < this.filters.length; ++i) {
            KeyedFilter filter = this.filters[i];
            long bucketOrd = this.bucketOrd(owningBucketOrdinal, i);
            InternalFilters.Bucket bucket = new InternalFilters.Bucket(filter.key, this.bucketDocCount(bucketOrd), this.bucketAggregations(bucketOrd));
            buckets.add(bucket);
        }
        return new InternalFilters(this.name, buckets, this.keyed);
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        InternalAggregations subAggs = this.buildEmptySubAggregations();
        ArrayList<InternalFilters.Bucket> buckets = Lists.newArrayListWithCapacity(this.filters.length);
        for (int i = 0; i < this.filters.length; ++i) {
            InternalFilters.Bucket bucket = new InternalFilters.Bucket(this.filters[i].key, 0L, subAggs);
            buckets.add(bucket);
        }
        return new InternalFilters(this.name, buckets, this.keyed);
    }

    private final long bucketOrd(long owningBucketOrdinal, int filterOrd) {
        return owningBucketOrdinal * (long)this.filters.length + (long)filterOrd;
    }

    public static class Factory
    extends AggregatorFactory {
        private final List<KeyedFilter> filters;
        private boolean keyed;

        public Factory(String name, List<KeyedFilter> filters, boolean keyed) {
            super(name, InternalFilters.TYPE.name());
            this.filters = filters;
            this.keyed = keyed;
        }

        @Override
        public Aggregator create(AggregationContext context, Aggregator parent, long expectedBucketsCount) {
            return new FiltersAggregator(this.name, this.factories, this.filters, this.keyed, context, parent);
        }
    }

    static class KeyedFilter {
        final String key;
        final Filter filter;

        KeyedFilter(String key, Filter filter) {
            this.key = key;
            this.filter = filter;
        }
    }
}

