/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.significant;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.bucket.significant.InternalSignificantTerms;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.JLHScore;

public class UnmappedSignificantTerms
extends InternalSignificantTerms {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("significant_terms", "umsigterms");
    private static final Collection<InternalSignificantTerms.Bucket> BUCKETS = Collections.emptyList();
    private static final Map<String, InternalSignificantTerms.Bucket> BUCKETS_MAP = Collections.emptyMap();
    public static final AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public UnmappedSignificantTerms readResult(StreamInput in) throws IOException {
            UnmappedSignificantTerms buckets = new UnmappedSignificantTerms();
            buckets.readFrom(in);
            return buckets;
        }
    };

    public static void registerStreams() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
    }

    UnmappedSignificantTerms() {
    }

    public UnmappedSignificantTerms(String name, int requiredSize, long minDocCount) {
        super(0L, 0L, name, requiredSize, minDocCount, JLHScore.INSTANCE, BUCKETS);
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    @Override
    public InternalAggregation reduce(InternalAggregation.ReduceContext reduceContext) {
        for (InternalAggregation aggregation : reduceContext.aggregations()) {
            if (aggregation instanceof UnmappedSignificantTerms) continue;
            return aggregation.reduce(reduceContext);
        }
        return this;
    }

    @Override
    InternalSignificantTerms newAggregation(long subsetSize, long supersetSize, List<InternalSignificantTerms.Bucket> buckets) {
        throw new UnsupportedOperationException("How did you get there?");
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readString();
        this.requiredSize = UnmappedSignificantTerms.readSize(in);
        this.minDocCount = in.readVLong();
        this.buckets = BUCKETS;
        this.bucketMap = BUCKETS_MAP;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        UnmappedSignificantTerms.writeSize(this.requiredSize, out);
        out.writeVLong(this.minDocCount);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(InternalAggregation.CommonFields.BUCKETS).endArray();
        return builder;
    }
}

