/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.bucket.terms.InternalOrder;
import org.elasticsearch.search.aggregations.bucket.terms.InternalTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;

public class UnmappedTerms
extends InternalTerms {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("terms", "umterms");
    private static final List<InternalTerms.Bucket> BUCKETS = Collections.emptyList();
    private static final Map<String, InternalTerms.Bucket> BUCKETS_MAP = Collections.emptyMap();
    public static final AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public UnmappedTerms readResult(StreamInput in) throws IOException {
            UnmappedTerms buckets = new UnmappedTerms();
            buckets.readFrom(in);
            return buckets;
        }
    };

    public static void registerStreams() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
    }

    UnmappedTerms() {
    }

    public UnmappedTerms(String name, Terms.Order order, int requiredSize, int shardSize, long minDocCount) {
        super(name, order, requiredSize, shardSize, minDocCount, BUCKETS, false, 0L, 0L);
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readString();
        this.docCountError = 0L;
        this.order = InternalOrder.Streams.readOrder(in);
        this.requiredSize = UnmappedTerms.readSize(in);
        this.minDocCount = in.readVLong();
        this.buckets = BUCKETS;
        this.bucketMap = BUCKETS_MAP;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        InternalOrder.Streams.writeOrder(this.order, out);
        UnmappedTerms.writeSize(this.requiredSize, out);
        out.writeVLong(this.minDocCount);
    }

    @Override
    public InternalAggregation reduce(InternalAggregation.ReduceContext reduceContext) {
        for (InternalAggregation agg : reduceContext.aggregations()) {
            if (agg instanceof UnmappedTerms) continue;
            return agg.reduce(reduceContext);
        }
        return this;
    }

    @Override
    protected InternalTerms newAggregation(String name, List<InternalTerms.Bucket> buckets, boolean showTermDocCountError, long docCountError, long otherDocCount) {
        throw new UnsupportedOperationException("How did you get there?");
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("doc_count_error_upper_bound", this.docCountError);
        builder.field("sum_other_doc_count", 0);
        builder.startArray(InternalAggregation.CommonFields.BUCKETS).endArray();
        return builder;
    }
}

