/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.rendition;

import javax.ws.rs.GET;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.rendition.Rendition;
import org.nuxeo.ecm.platform.rendition.service.RenditionService;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="rendition")
public class RenditionObject
extends DefaultObject {
    protected String renditionName;
    protected DocumentModel doc;

    protected void initialize(Object ... args) {
        assert (args != null && args.length == 2);
        this.doc = (DocumentModel)args[0];
        this.renditionName = (String)args[1];
    }

    public <A> A getAdapter(Class<A> adapter) {
        if (adapter.isAssignableFrom(Blob.class)) {
            return adapter.cast(this.getRenditionBlob());
        }
        return (A)super.getAdapter(adapter);
    }

    protected Blob getRenditionBlob() {
        RenditionService renditionService = (RenditionService)Framework.getService(RenditionService.class);
        Rendition rendition = renditionService.getRendition(this.doc, this.renditionName);
        if (rendition == null) {
            throw new WebResourceNotFoundException(String.format("No rendition '%s' was found", this.renditionName));
        }
        return rendition.getBlob();
    }

    @GET
    public Object doGet(@Context Request request) {
        Blob blob = this.getRenditionBlob();
        if (blob == null) {
            throw new WebResourceNotFoundException(String.format("No Blob was found for rendition '%s'", this.renditionName));
        }
        return blob;
    }
}

