/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.api.document;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.platform.audit.api.AuditPageProvider;
import org.nuxeo.ecm.platform.audit.api.document.AdditionalDocumentAuditParams;
import org.nuxeo.ecm.platform.audit.api.document.DocumentAuditHelper;

public class DocumentHistoryPageProvider
extends AuditPageProvider {
    private static final long serialVersionUID = 1L;
    protected Log log = LogFactory.getLog(DocumentHistoryPageProvider.class);
    protected Object[] newParams;

    @Override
    protected String getFixedPart() {
        if (this.getParameters().length == 3) {
            return " ( log.docUUID = ? OR (log.docUUID = ? AND log.eventDate <= ?) ) ";
        }
        return " log.docUUID = ?  ";
    }

    @Override
    protected boolean allowSimplePattern() {
        return false;
    }

    public List<SortInfo> getSortInfos() {
        ArrayList<SortInfo> sort = super.getSortInfos();
        if (sort == null || sort.size() == 0) {
            sort = new ArrayList<SortInfo>();
            sort.add(new SortInfo("log.eventDate", true));
            sort.add(new SortInfo("log.id", true));
        }
        return sort;
    }

    public Object[] getParameters() {
        if (this.newParams == null) {
            Object[] params = super.getParameters();
            if (params.length != 1) {
                this.log.error((Object)(((Object)((Object)this)).getClass().getSimpleName() + " Expect only one parameter the document uuid, unexpected behavior may occur"));
            }
            CoreSession session = null;
            String uuid = null;
            if (params[0] instanceof DocumentModel) {
                DocumentModel doc = (DocumentModel)params[0];
                uuid = doc.getId();
                session = doc.getCoreSession();
            } else {
                session = (CoreSession)this.getProperties().get("coreSession");
                uuid = params[0].toString();
            }
            if (session != null) {
                AdditionalDocumentAuditParams additionalParams = DocumentAuditHelper.getAuditParamsForUUID(uuid, session);
                this.newParams = additionalParams != null ? new Object[]{uuid, additionalParams.targetUUID, additionalParams.maxDate} : new Object[]{uuid};
            } else {
                this.log.warn((Object)"No core session found: cannot compute all info to get complete audit entries");
                return params;
            }
        }
        return this.newParams;
    }

    public boolean hasChangedParameters(Object[] parameters) {
        return this.getParametersChanged(this.parameters, parameters);
    }
}

