/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.api.adapters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.DocumentBlobHolder;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.platform.picture.api.adapters.PictureResourceAdapter;

public class PictureBlobHolder
extends DocumentBlobHolder {
    public PictureBlobHolder(DocumentModel doc, String path) {
        super(doc, path);
    }

    public List<Blob> getBlobs() {
        ArrayList<Blob> blobList = new ArrayList<Blob>();
        Blob mainBlob = this.getBlob();
        if (mainBlob != null) {
            blobList.add(this.getBlob());
        }
        Collection views = this.doc.getProperty("picture:views").getChildren();
        for (Property property : views) {
            blobList.add((Blob)property.getValue("content"));
        }
        return blobList;
    }

    public List<Blob> getBlobs(String ... viewNames) {
        ArrayList<Blob> blobList = new ArrayList<Blob>();
        for (String viewName : viewNames) {
            blobList.add(this.getBlob(viewName));
        }
        return blobList;
    }

    public Blob getBlob(String title) {
        PictureResourceAdapter picture = (PictureResourceAdapter)this.doc.getAdapter(PictureResourceAdapter.class);
        return picture.getPictureFromTitle(title);
    }

    public String getHash() {
        String h;
        Blob blob = this.getBlob();
        if (blob != null && (h = blob.getDigest()) != null) {
            return h;
        }
        return this.doc.getId() + this.xPath + this.getModificationDate().toString();
    }
}

