/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.commands;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;

public class IndexingCommand
implements Serializable {
    private static final Log log = LogFactory.getLog(IndexingCommand.class);
    private static final long serialVersionUID = 1L;
    public static final String PREFIX = "IxCd-";
    protected String id;
    protected Type type;
    protected boolean sync;
    protected boolean recurse;
    protected String targetDocumentId;
    protected String path;
    protected String repositoryName;
    protected List<String> schemas;
    protected long order;
    protected transient String sessionId;
    protected static transient AtomicLong seq = new AtomicLong(0L);

    protected IndexingCommand() {
    }

    public IndexingCommand(DocumentModel document, Type commandType, boolean sync, boolean recurse) {
        this.id = PREFIX + seq.incrementAndGet();
        this.type = commandType;
        this.sync = sync;
        this.recurse = recurse;
        if (sync && recurse && commandType != Type.DELETE) {
            throw new IllegalArgumentException("Recurse and synchronous command is not allowed: cmd: " + this + ", doc: " + document);
        }
        if (document == null) {
            throw new IllegalArgumentException("Target document is null for: " + this);
        }
        DocumentModel targetDocument = this.getValidTargetDocument(document);
        this.repositoryName = targetDocument.getRepositoryName();
        this.targetDocumentId = targetDocument.getId();
        this.sessionId = targetDocument.getSessionId();
        this.path = targetDocument.getPathAsString();
        if (this.targetDocumentId == null) {
            throw new IllegalArgumentException("Target document has a null uid: " + this);
        }
    }

    protected DocumentModel getValidTargetDocument(DocumentModel target) {
        if (target.getId() != null) {
            return target;
        }
        if (target.getRef() == null || target.getCoreSession() == null) {
            throw new IllegalArgumentException("Invalid target document: " + target);
        }
        DocumentRef documentRef = target.getRef();
        log.warn((Object)("Creating indexing command on a document with a null id, ref: " + documentRef + ", trying to get the docId from its path, activate trace level for more info " + this));
        if (log.isTraceEnabled()) {
            Throwable throwable = new Throwable();
            StringWriter stack = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stack));
            log.trace((Object)("You should use a document returned by session.createDocument, stack " + stack.toString()));
        }
        return target.getCoreSession().getDocument(documentRef);
    }

    public void attach(CoreSession session) {
        if (!session.getRepositoryName().equals(this.repositoryName)) {
            throw new IllegalArgumentException("Invalid session, expected repo: " + this.repositoryName + " actual: " + session.getRepositoryName());
        }
        this.sessionId = session.getSessionId();
        assert (this.sessionId != null) : "Attach to session with a null sessionId";
    }

    public DocumentModel getTargetDocument() {
        CoreSession session = null;
        if (this.sessionId != null) {
            session = CoreInstance.getInstance().getSession(this.sessionId);
        }
        if (session == null) {
            throw new IllegalStateException("Command is not attached to a valid session: " + this);
        }
        IdRef idref = new IdRef(this.targetDocumentId);
        if (!session.exists((DocumentRef)idref)) {
            return null;
        }
        return session.getDocument((DocumentRef)idref);
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public boolean merge(IndexingCommand other) {
        if (this.canBeMerged(other)) {
            this.merge(other.sync, other.recurse);
            return true;
        }
        return false;
    }

    protected void merge(boolean sync, boolean recurse) {
        this.sync = this.sync || sync;
        this.recurse = this.recurse || recurse;
    }

    protected boolean canBeMerged(IndexingCommand other) {
        if (this.type != other.type) {
            return false;
        }
        if (this.type == Type.DELETE) {
            return true;
        }
        return !other.sync && !this.sync || !other.recurse && !this.recurse;
    }

    public boolean isSync() {
        return this.sync;
    }

    public boolean isRecurse() {
        return this.recurse;
    }

    public Type getType() {
        return this.type;
    }

    public String toJSON() throws IOException {
        StringWriter out = new StringWriter();
        JsonFactory factory = new JsonFactory();
        JsonGenerator jsonGen = factory.createJsonGenerator((Writer)out);
        this.toJSON(jsonGen);
        out.flush();
        jsonGen.close();
        return out.toString();
    }

    public void toJSON(JsonGenerator jsonGen) throws IOException {
        jsonGen.writeStartObject();
        jsonGen.writeStringField("id", this.id);
        jsonGen.writeStringField("type", String.format("%s", new Object[]{this.type}));
        jsonGen.writeStringField("docId", this.getTargetDocumentId());
        jsonGen.writeStringField("path", this.path);
        jsonGen.writeStringField("repo", this.getRepositoryName());
        jsonGen.writeBooleanField("recurse", this.recurse);
        jsonGen.writeBooleanField("sync", this.sync);
        jsonGen.writeNumberField("order", this.getOrder());
        jsonGen.writeEndObject();
    }

    public static IndexingCommand fromJSON(String json) {
        JsonFactory jsonFactory = new JsonFactory();
        ObjectMapper mapper = new ObjectMapper(jsonFactory);
        try {
            return IndexingCommand.fromJSON(mapper.readTree(json));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid JSON: " + json, e);
        }
    }

    public static IndexingCommand fromJSON(JsonNode jsonNode) {
        IndexingCommand cmd = new IndexingCommand();
        Iterator fieldsIterator = jsonNode.getFields();
        while (fieldsIterator.hasNext()) {
            Map.Entry field = (Map.Entry)fieldsIterator.next();
            String key = (String)field.getKey();
            JsonNode value = (JsonNode)field.getValue();
            if (value.isNull()) continue;
            if ("type".equals(key)) {
                cmd.type = Type.valueOf(value.getTextValue());
                continue;
            }
            if ("docId".equals(key)) {
                cmd.targetDocumentId = value.getTextValue();
                continue;
            }
            if ("path".equals(key)) {
                cmd.path = value.getTextValue();
                continue;
            }
            if ("repo".equals(key)) {
                cmd.repositoryName = value.getTextValue();
                continue;
            }
            if ("id".equals(key)) {
                cmd.id = value.getTextValue();
                continue;
            }
            if ("recurse".equals(key)) {
                cmd.recurse = value.getBooleanValue();
                continue;
            }
            if (!"sync".equals(key)) continue;
            cmd.sync = value.getBooleanValue();
        }
        if (cmd.targetDocumentId == null) {
            throw new IllegalArgumentException("Document uid is null: " + cmd);
        }
        if (cmd.type == null) {
            throw new IllegalArgumentException("Invalid type: " + cmd);
        }
        return cmd;
    }

    public String getId() {
        return this.id;
    }

    public String getTargetDocumentId() {
        return this.targetDocumentId;
    }

    public IndexingCommand clone(DocumentModel newDoc) {
        return new IndexingCommand(newDoc, this.type, this.sync, this.recurse);
    }

    public String[] getSchemas() {
        String[] ret = null;
        if (this.schemas != null && this.schemas.size() > 0) {
            ret = this.schemas.toArray(new String[this.schemas.size()]);
        }
        return ret;
    }

    public void addSchemas(String schema) {
        if (this.schemas == null) {
            this.schemas = new ArrayList<String>();
        }
        if (!this.schemas.contains(schema)) {
            this.schemas.add(schema);
        }
    }

    public String toString() {
        try {
            return this.toJSON();
        }
        catch (IOException e) {
            return super.toString();
        }
    }

    public void makeSync() {
        if (!(this.sync || this.recurse && this.type != Type.DELETE)) {
            this.sync = true;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Turn command into sync: " + this.toString()));
            }
        }
    }

    public long getOrder() {
        return this.order;
    }

    public void setOrder(long order) {
        this.order = order;
    }

    public static enum Type {
        INSERT,
        UPDATE,
        UPDATE_SECURITY,
        DELETE,
        UPDATE_DIRECT_CHILDREN;

    }
}

