/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.osgi;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.osgi.BundleFile;
import org.nuxeo.osgi.BundleManifestReader;
import org.nuxeo.osgi.JarBundleFile;
import org.nuxeo.osgi.OSGiAdapter;
import org.nuxeo.osgi.util.CompoundEnumeration;
import org.nuxeo.osgi.util.EntryFilter;
import org.nuxeo.osgi.util.FileIterator;

public class DirectoryBundleFile
implements BundleFile {
    public static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    protected final File file;
    protected final List<File> files;
    protected final Manifest mf;

    public DirectoryBundleFile(File file) throws IOException {
        this(file, null);
    }

    public DirectoryBundleFile(File file, Manifest mf) throws IOException {
        this.file = file;
        this.files = this.findFiles(file);
        this.mf = mf == null ? this.findManifest() : mf;
    }

    protected List<File> findFiles(File file) {
        ArrayList<File> files = new ArrayList<File>(2);
        files.add(file);
        if (file.getPath().endsWith("/bin")) {
            files.add(file.getParentFile());
        } else if (file.getPath().endsWith("/target/classes")) {
            files.add(file.getParentFile().getParentFile());
        }
        return files;
    }

    private Enumeration<URL> createEnumeration(File root, final EntryFilter efilter, final boolean recurse) {
        FileIterator it = new FileIterator(root, new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.isDirectory()) {
                    return recurse;
                }
                return efilter.match(pathname.getName());
            }
        });
        it.setSkipDirs(true);
        return FileIterator.asUrlEnumeration(it);
    }

    @Override
    public Enumeration<URL> findEntries(String name, String pattern, boolean recurse) {
        EntryFilter efilter = EntryFilter.newFilter(pattern);
        if (this.files.size() == 1) {
            return this.createEnumeration(new File(this.file, name), efilter, recurse);
        }
        Enumeration[] enums = new Enumeration[this.files.size()];
        int i = 0;
        for (File f : this.files) {
            enums[i++] = this.createEnumeration(new File(f, name), efilter, recurse);
        }
        return new CompoundEnumeration<URL>(enums);
    }

    @Override
    public URL getEntry(String name) {
        for (File file : this.files) {
            File entry = new File(file, name);
            if (!entry.exists()) continue;
            try {
                return entry.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
            }
        }
        return null;
    }

    @Override
    public Enumeration<String> getEntryPaths(String path) {
        throw new UnsupportedOperationException("The operation BundleFile.geEntryPaths() is not yet implemented");
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public String getFileName() {
        return this.file.getName();
    }

    @Override
    public String getLocation() {
        return this.file.getPath();
    }

    @Override
    public Manifest getManifest() {
        return this.mf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Manifest findManifest() throws IOException {
        for (File file : this.files) {
            File entry = new File(file, MANIFEST_PATH);
            if (!entry.exists()) continue;
            try (FileInputStream fis = new FileInputStream(entry);){
                Manifest manifest = new Manifest(fis);
                return manifest;
            }
        }
        String paths = StringUtils.join((Object[])this.files.toArray(new Object[this.files.size()]), (String)", ");
        throw new IOException(String.format("Could not find a file '%s' in paths: %s", MANIFEST_PATH, paths));
    }

    @Override
    public Collection<BundleFile> getNestedBundles(File tmpDir) throws IOException {
        Attributes attrs = this.mf.getMainAttributes();
        String cp = attrs.getValue("Bundle-ClassPath");
        if (cp == null) {
            cp = attrs.getValue("Class-Path");
        }
        if (cp == null) {
            return null;
        }
        String[] paths = StringUtils.split((String)cp, (char)',', (boolean)true);
        ArrayList<BundleFile> nested = new ArrayList<BundleFile>();
        for (String path : paths) {
            File nestedBundle = new File(this.file, path);
            if (nestedBundle.isDirectory()) {
                nested.add(new DirectoryBundleFile(nestedBundle));
                continue;
            }
            nested.add(new JarBundleFile(nestedBundle));
        }
        return nested;
    }

    @Override
    public Collection<BundleFile> findNestedBundles(File tmpDir) throws IOException {
        File[] files;
        ArrayList<BundleFile> nested = new ArrayList<BundleFile>();
        for (File jar : files = FileUtils.findFiles((File)this.file, (String)"*.jar", (boolean)true)) {
            if (jar.isDirectory()) {
                nested.add(new DirectoryBundleFile(jar));
                continue;
            }
            nested.add(new JarBundleFile(jar));
        }
        return nested;
    }

    @Override
    public String getSymbolicName() {
        String value = this.mf.getMainAttributes().getValue("Bundle-SymbolicName");
        return value == null ? null : BundleManifestReader.removePropertiesFromHeaderValue(value);
    }

    @Override
    public URL getURL() {
        try {
            return this.file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public boolean isJar() {
        return false;
    }

    public String toString() {
        return this.getLocation();
    }

    public static void main(String[] args) throws Exception {
        DirectoryBundleFile bf = new DirectoryBundleFile(new File("/Users/bstefanescu/work/org.eclipse.ecr/plugins/org.eclipse.ecr.application/bin"));
        Enumeration<URL> urls = bf.findEntries("META-INF", "*.txt", false);
        while (urls.hasMoreElements()) {
            System.out.println(urls.nextElement());
        }
    }

    @Override
    public void close(OSGiAdapter osgi) throws IOException {
    }
}

