/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpExtBuilder;
import com.hp.hpl.jena.sparql.algebra.OpExtRegistry;
import com.hp.hpl.jena.sparql.algebra.Table;
import com.hp.hpl.jena.sparql.algebra.TableFactory;
import com.hp.hpl.jena.sparql.algebra.Transform;
import com.hp.hpl.jena.sparql.algebra.Transformer;
import com.hp.hpl.jena.sparql.algebra.op.OpAssign;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpDistinct;
import com.hp.hpl.jena.sparql.algebra.op.OpExtend;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.algebra.op.OpGroup;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpLabel;
import com.hp.hpl.jena.sparql.algebra.op.OpLeftJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpList;
import com.hp.hpl.jena.sparql.algebra.op.OpMinus;
import com.hp.hpl.jena.sparql.algebra.op.OpNull;
import com.hp.hpl.jena.sparql.algebra.op.OpOrder;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.op.OpReduced;
import com.hp.hpl.jena.sparql.algebra.op.OpSequence;
import com.hp.hpl.jena.sparql.algebra.op.OpService;
import com.hp.hpl.jena.sparql.algebra.op.OpSlice;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.algebra.op.OpUnion;
import com.hp.hpl.jena.sparql.algebra.optimize.TransformSimplify;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.PathBlock;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.E_Exists;
import com.hp.hpl.jena.sparql.expr.E_LogicalNot;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.ExprLib;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.path.PathCompiler;
import com.hp.hpl.jena.sparql.path.PathLib;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.ItemList;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementAssign;
import com.hp.hpl.jena.sparql.syntax.ElementBind;
import com.hp.hpl.jena.sparql.syntax.ElementExists;
import com.hp.hpl.jena.sparql.syntax.ElementFetch;
import com.hp.hpl.jena.sparql.syntax.ElementFilter;
import com.hp.hpl.jena.sparql.syntax.ElementGroup;
import com.hp.hpl.jena.sparql.syntax.ElementMinus;
import com.hp.hpl.jena.sparql.syntax.ElementNamedGraph;
import com.hp.hpl.jena.sparql.syntax.ElementNotExists;
import com.hp.hpl.jena.sparql.syntax.ElementOptional;
import com.hp.hpl.jena.sparql.syntax.ElementPathBlock;
import com.hp.hpl.jena.sparql.syntax.ElementService;
import com.hp.hpl.jena.sparql.syntax.ElementSubQuery;
import com.hp.hpl.jena.sparql.syntax.ElementTriplesBlock;
import com.hp.hpl.jena.sparql.syntax.ElementUnion;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.openjena.atlas.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlgebraGenerator {
    private boolean fixedFilterPosition = false;
    private Context context;
    private PathCompiler pathCompiler = new PathCompiler();
    private int subQueryDepth = 0;
    private static final boolean applySimplification = true;
    private static final boolean simplifyTooEarlyInAlgebraGeneration = false;
    protected static Transform simplify = new TransformSimplify();

    public AlgebraGenerator(Context context) {
        if (context == null) {
            context = ARQ.getContext().copy();
        }
        this.context = context;
    }

    public AlgebraGenerator() {
        this(null);
    }

    public Op compile(Query query2) {
        Op pattern = this.compile(query2.getQueryPattern());
        Op op = this.compileModifiers(query2, pattern);
        if (query2.hasBindings()) {
            List<Binding> bindings = query2.getBindingValues();
            Table table = TableFactory.create();
            for (Binding binding : bindings) {
                table.addBinding(binding);
            }
            OpTable opTable = OpTable.create(table);
            op = OpJoin.create(op, opTable);
        }
        return op;
    }

    public Op compile(Element elt) {
        Op op;
        Op op2 = op = this.compileElement(elt);
        if (simplify != null) {
            op2 = AlgebraGenerator.simplify(op);
        }
        return op2;
    }

    private static Op simplify(Op op) {
        return Transformer.transform(simplify, op);
    }

    protected Op compileElement(Element elt) {
        if (elt instanceof ElementUnion) {
            return this.compileElementUnion((ElementUnion)elt);
        }
        if (elt instanceof ElementGroup) {
            return this.compileElementGroup((ElementGroup)elt);
        }
        if (elt instanceof ElementNamedGraph) {
            return this.compileElementGraph((ElementNamedGraph)elt);
        }
        if (elt instanceof ElementService) {
            return this.compileElementService((ElementService)elt);
        }
        if (elt instanceof ElementFetch) {
            return this.compileElementFetch((ElementFetch)elt);
        }
        if (elt instanceof ElementTriplesBlock) {
            return this.compileBasicPattern(((ElementTriplesBlock)elt).getPattern());
        }
        if (elt instanceof ElementPathBlock) {
            return this.compilePathBlock(((ElementPathBlock)elt).getPattern());
        }
        if (elt instanceof ElementSubQuery) {
            return this.compileElementSubquery((ElementSubQuery)elt);
        }
        if (elt == null) {
            return OpNull.create();
        }
        this.broken("compile(Element)/Not a structural element: " + Utils.className(elt));
        return null;
    }

    protected Op compileElementUnion(ElementUnion el) {
        Op current = null;
        for (Element subElt : el.getElements()) {
            Op op = this.compileElement(subElt);
            current = this.union(current, op);
        }
        return current;
    }

    protected Op compileElementGroup(ElementGroup groupElt) {
        Op current = OpTable.unit();
        List<Element> groupElts = this.finalizeSyntax(groupElt);
        ListIterator<Element> iter = groupElts.listIterator();
        while (iter.hasNext()) {
            Element elt = (Element)iter.next();
            current = this.compileOneInGroup(elt, current);
        }
        return current;
    }

    private List<Element> finalizeSyntax(ElementGroup groupElt) {
        if (this.fixedFilterPosition) {
            return groupElt.getElements();
        }
        ArrayList<Element> groupElts = new ArrayList<Element>();
        BasicPattern prev = null;
        ArrayList<ElementFilter> filters = null;
        PathBlock prev2 = null;
        for (Element elt : groupElt.getElements()) {
            if (elt instanceof ElementFilter) {
                ElementFilter f = (ElementFilter)elt;
                if (filters == null) {
                    filters = new ArrayList<ElementFilter>();
                }
                filters.add(f);
                continue;
            }
            if (elt instanceof ElementTriplesBlock) {
                if (prev2 != null) {
                    throw new ARQInternalErrorException("Mixed ElementTriplesBlock and ElementPathBlock (case 1)");
                }
                ElementTriplesBlock etb = (ElementTriplesBlock)elt;
                if (prev != null) {
                    prev.addAll(etb.getPattern());
                    continue;
                }
                ElementTriplesBlock etb2 = new ElementTriplesBlock();
                etb2.getPattern().addAll(etb.getPattern());
                prev = etb2.getPattern();
                groupElts.add(etb2);
                continue;
            }
            if (elt instanceof ElementPathBlock) {
                if (prev != null) {
                    throw new ARQInternalErrorException("Mixed ElementTriplesBlock and ElementPathBlock (case 2)");
                }
                ElementPathBlock epb = (ElementPathBlock)elt;
                if (prev2 != null) {
                    prev2.addAll(epb.getPattern());
                    continue;
                }
                ElementPathBlock epb2 = new ElementPathBlock();
                epb2.getPattern().addAll(epb.getPattern());
                prev2 = epb2.getPattern();
                groupElts.add(epb2);
                continue;
            }
            prev = null;
            prev2 = null;
            groupElts.add(elt);
        }
        if (filters != null) {
            groupElts.addAll(filters);
        }
        return groupElts;
    }

    private Op compileOneInGroup(Element elt, Op current) {
        if (elt instanceof ElementTriplesBlock) {
            ElementTriplesBlock etb = (ElementTriplesBlock)elt;
            Op op = this.compileBasicPattern(etb.getPattern());
            return this.join(current, op);
        }
        if (elt instanceof ElementPathBlock) {
            ElementPathBlock epb = (ElementPathBlock)elt;
            Op op = this.compilePathBlock(epb.getPattern());
            return this.join(current, op);
        }
        if (elt instanceof ElementFilter) {
            ElementFilter f = (ElementFilter)elt;
            return OpFilter.filter(f.getExpr(), current);
        }
        if (elt instanceof ElementOptional) {
            ElementOptional eltOpt = (ElementOptional)elt;
            return this.compileElementOptional(eltOpt, current);
        }
        if (elt instanceof ElementSubQuery) {
            ElementSubQuery elQuery = (ElementSubQuery)elt;
            Op op = this.compileElementSubquery(elQuery);
            return this.join(current, op);
        }
        if (elt instanceof ElementAssign) {
            ElementAssign assign2 = (ElementAssign)elt;
            Op op = OpAssign.assign(current, assign2.getVar(), assign2.getExpr());
            return op;
        }
        if (elt instanceof ElementBind) {
            ElementBind bind = (ElementBind)elt;
            Op op = OpExtend.extend(current, bind.getVar(), bind.getExpr());
            return op;
        }
        if (elt instanceof ElementExists) {
            ElementExists elt2 = (ElementExists)elt;
            Op op = this.compileElementExists(current, elt2);
            return op;
        }
        if (elt instanceof ElementNotExists) {
            ElementNotExists elt2 = (ElementNotExists)elt;
            Op op = this.compileElementNotExists(current, elt2);
            return op;
        }
        if (elt instanceof ElementMinus) {
            ElementMinus elt2 = (ElementMinus)elt;
            Op op = this.compileElementMinus(current, elt2);
            return op;
        }
        if (elt instanceof ElementGroup || elt instanceof ElementNamedGraph || elt instanceof ElementService || elt instanceof ElementFetch || elt instanceof ElementUnion) {
            Op op = this.compileElement(elt);
            return this.join(current, op);
        }
        this.broken("compile/Element not recognized: " + Utils.className(elt));
        return null;
    }

    private Op compileElementNotExists(Op current, ElementNotExists elt2) {
        Op op = this.compile(elt2.getElement());
        ExprFunction expr = new E_Exists(elt2, op);
        expr = new E_LogicalNot(expr);
        return OpFilter.filter(expr, current);
    }

    private Op compileElementExists(Op current, ElementExists elt2) {
        Op op = this.compile(elt2.getElement());
        E_Exists expr = new E_Exists(elt2, op);
        return OpFilter.filter(expr, current);
    }

    private Op compileElementMinus(Op current, ElementMinus elt2) {
        Op op = this.compile(elt2.getMinusElement());
        Op opMinus = OpMinus.create(current, op);
        return opMinus;
    }

    private Op compileElementUnion(Op current, ElementUnion elt2) {
        Op op = this.compile(elt2.getElements().get(0));
        Op opUnion = OpUnion.create(current, op);
        return opUnion;
    }

    protected Op compileElementOptional(ElementOptional eltOpt, Op current) {
        Element subElt = eltOpt.getOptionalElement();
        Op op = this.compileElement(subElt);
        ExprList exprs = null;
        if (op instanceof OpFilter) {
            OpFilter f = (OpFilter)op;
            Op sub = f.getSubOp();
            if (sub instanceof OpFilter) {
                this.broken("compile/Optional/nested filters - unfinished");
            }
            exprs = f.getExprs();
            op = sub;
        }
        current = OpLeftJoin.create(current, op, exprs);
        return current;
    }

    protected Op compileBasicPattern(BasicPattern pattern) {
        return new OpBGP(pattern);
    }

    protected Op compilePathBlock(PathBlock pathBlock) {
        if (pathBlock.size() == 0) {
            return OpTable.unit();
        }
        return PathLib.pathToTriples(pathBlock);
    }

    protected Op compileElementGraph(ElementNamedGraph eltGraph) {
        Node graphNode = eltGraph.getGraphNameNode();
        Op sub = this.compileElement(eltGraph.getElement());
        return new OpGraph(graphNode, sub);
    }

    protected Op compileElementService(ElementService eltService) {
        Node serviceNode = eltService.getServiceNode();
        Op sub = this.compileElement(eltService.getElement());
        return new OpService(serviceNode, sub, eltService, eltService.getSilent());
    }

    private Op compileElementFetch(ElementFetch elt) {
        Node serviceNode = elt.getFetchNode();
        OpExtBuilder builder = OpExtRegistry.builder("fetch");
        if (builder == null) {
            Log.warn(this, "Attempt to use OpFetch - need to enable first with a call to OpFetch.enable()");
            return OpLabel.create("fetch/" + serviceNode, OpTable.unit());
        }
        Item item = Item.createNode(elt.getFetchNode());
        ItemList args = new ItemList();
        args.add(item);
        return builder.make(args);
    }

    protected Op compileElementSubquery(ElementSubQuery eltSubQuery) {
        ++this.subQueryDepth;
        Op sub = this.compile(eltSubQuery.getQuery());
        --this.subQueryDepth;
        return sub;
    }

    public Op compileModifiers(Query query2, Op pattern) {
        VarExprList projectVars = query2.getProject();
        VarExprList exprs = new VarExprList();
        ArrayList<Var> vars = new ArrayList<Var>();
        Op op = pattern;
        if (this.context.isTrue(ARQ.generateToList)) {
            op = new OpList(op);
        }
        if (query2.hasGroupBy()) {
            op = new OpGroup(op, query2.getGroupBy(), query2.getAggregators());
        }
        if (!projectVars.isEmpty() && !query2.isQueryResultStar()) {
            if (projectVars.size() == 0 && query2.isSelectType()) {
                Log.warn(this, "No project variables");
            }
            for (Var v : query2.getProject().getVars()) {
                Expr e2 = query2.getProject().getExpr(v);
                if (e2 != null) {
                    Expr e22 = ExprLib.replaceAggregateByVariable(e2);
                    exprs.add(v, e22);
                }
                vars.add(v);
            }
        }
        if (!exprs.isEmpty()) {
            op = OpExtend.extend(op, exprs);
        }
        if (query2.hasHaving()) {
            for (Expr expr : query2.getHavingExprs()) {
                Expr expr2 = ExprLib.replaceAggregateByVariable(expr);
                op = OpFilter.filter(expr2, op);
            }
        }
        if (query2.getOrderBy() != null) {
            op = new OpOrder(op, query2.getOrderBy());
        }
        if (vars.size() > 0) {
            op = new OpProject(op, vars);
        }
        if (query2.isDistinct()) {
            op = OpDistinct.create(op);
        }
        if (query2.isReduced()) {
            op = OpReduced.create(op);
        }
        if (query2.hasLimit() || query2.hasOffset()) {
            op = new OpSlice(op, query2.getOffset(), query2.getLimit());
        }
        return op;
    }

    protected Op join(Op current, Op newOp) {
        return OpJoin.create(current, newOp);
    }

    protected Op sequence(Op current, Op newOp) {
        return OpSequence.create(current, newOp);
    }

    protected Op union(Op current, Op newOp) {
        return OpUnion.create(current, newOp);
    }

    private void broken(String msg) {
        throw new ARQInternalErrorException(msg);
    }
}

