/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.lang;

import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.sparql.lang.ParserARQUpdate;
import com.hp.hpl.jena.sparql.lang.ParserSPARQL11Update;
import com.hp.hpl.jena.sparql.lang.UpdateParser;
import com.hp.hpl.jena.sparql.lang.UpdateParserFactory;
import java.util.HashMap;
import java.util.Map;

public class UpdateParserRegistry {
    Map<Syntax, UpdateParserFactory> factories = new HashMap<Syntax, UpdateParserFactory>();
    static UpdateParserRegistry registry = null;

    public static synchronized UpdateParserRegistry get() {
        if (registry == null) {
            UpdateParserRegistry.init();
        }
        return registry;
    }

    private UpdateParserRegistry() {
    }

    private static synchronized void init() {
        UpdateParserRegistry reg = new UpdateParserRegistry();
        reg.add(Syntax.syntaxSPARQL_11, new UpdateParserFactory(){

            public boolean accept(Syntax syntax) {
                return Syntax.syntaxSPARQL_11.equals(syntax);
            }

            public UpdateParser create(Syntax syntax) {
                return new ParserSPARQL11Update();
            }
        });
        reg.add(Syntax.syntaxARQ, new UpdateParserFactory(){

            public boolean accept(Syntax syntax) {
                return Syntax.syntaxARQ.equals(syntax);
            }

            public UpdateParser create(Syntax syntax) {
                return new ParserARQUpdate();
            }
        });
        registry = reg;
    }

    public static UpdateParserFactory findFactory(Syntax syntax) {
        return UpdateParserRegistry.get().getFactory(syntax);
    }

    public static UpdateParser parser(Syntax syntax) {
        return UpdateParserRegistry.get().createParser(syntax);
    }

    public UpdateParserFactory getFactory(Syntax syntax) {
        return this.factories.get(syntax);
    }

    public UpdateParser createParser(Syntax syntax) {
        UpdateParserFactory f = this.getFactory(syntax);
        return f != null ? f.create(syntax) : null;
    }

    public static void addFactory(Syntax syntax, UpdateParserFactory f) {
        UpdateParserRegistry.get().add(syntax, f);
    }

    public void add(Syntax syntax, UpdateParserFactory f) {
        if (!f.accept(syntax)) {
            throw new IllegalArgumentException("The given parser factory does not accept the specified syntax.");
        }
        this.factories.put(syntax, f);
    }

    public static void removeFactory(Syntax syntax) {
        UpdateParserRegistry.get().remove(syntax);
    }

    public void remove(Syntax syntax) {
        this.factories.remove(syntax);
    }

    public static boolean containsParserFactory(Syntax syntax) {
        return UpdateParserRegistry.get().containsFactory(syntax);
    }

    public boolean containsFactory(Syntax syntax) {
        return this.factories.containsKey(syntax);
    }
}

