/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.api.login;

import java.io.Serializable;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.api.RuntimeInstanceIdentifier;
import org.nuxeo.runtime.api.login.CredentialsCallbackHandler;
import org.nuxeo.runtime.api.login.LoginConfiguration;
import org.nuxeo.runtime.api.login.LoginService;
import org.nuxeo.runtime.api.login.SecurityDomain;
import org.nuxeo.runtime.api.login.SystemLoginPermission;
import org.nuxeo.runtime.api.login.SystemLoginRestrictionManager;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

public class LoginComponent
extends DefaultComponent
implements LoginService {
    public static final ComponentName NAME = new ComponentName("org.nuxeo.runtime.LoginComponent");
    public static final String SYSTEM_LOGIN = "nuxeo-system-login";
    public static final String CLIENT_LOGIN = "nuxeo-client-login";
    public static final String SYSTEM_USERNAME = "system";
    protected static final String instanceId = RuntimeInstanceIdentifier.getId();
    protected static final SystemLoginRestrictionManager systemLoginManager = new SystemLoginRestrictionManager();
    protected static final Log log = LogFactory.getLog(LoginComponent.class);
    private final Map<String, SecurityDomain> domains = new Hashtable<String, SecurityDomain>();
    private SecurityDomain systemLogin;
    private SecurityDomain clientLogin;

    @Override
    public void activate(ComponentContext context) {
        LoginConfiguration.INSTANCE.install(new LoginConfiguration.Provider(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                return LoginComponent.this.getAppConfigurationEntry(name);
            }
        });
    }

    @Override
    public void deactivate(ComponentContext context) {
        LoginConfiguration.INSTANCE.uninstall();
    }

    @Override
    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals("domains")) {
            SecurityDomain domain = (SecurityDomain)contribution;
            this.addSecurityDomain(domain);
        }
    }

    @Override
    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals("domains")) {
            SecurityDomain domain = (SecurityDomain)contribution;
            this.removeSecurityDomain(domain.getName());
        }
    }

    public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
        SecurityDomain domain = this.domains.get(name);
        if (domain != null) {
            return domain.getAppConfigurationEntries();
        }
        return null;
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (LoginService.class.isAssignableFrom(adapter)) {
            return (T)this;
        }
        return null;
    }

    @Override
    public SecurityDomain getSecurityDomain(String name) {
        return this.domains.get(name);
    }

    @Override
    public void addSecurityDomain(SecurityDomain domain) {
        this.domains.put(domain.getName(), domain);
        if (SYSTEM_LOGIN.equals(domain.getName())) {
            this.systemLogin = domain;
        } else if (CLIENT_LOGIN.equals(domain.getName())) {
            this.clientLogin = domain;
        }
    }

    @Override
    public void removeSecurityDomain(String name) {
        this.domains.remove(name);
        if (SYSTEM_LOGIN.equals(name)) {
            this.systemLogin = null;
        } else if (CLIENT_LOGIN.equals(name)) {
            this.clientLogin = null;
        }
    }

    @Override
    public SecurityDomain[] getSecurityDomains() {
        return this.domains.values().toArray(new SecurityDomain[this.domains.size()]);
    }

    @Override
    public void removeSecurityDomains() {
        this.domains.clear();
        this.systemLogin = null;
        this.clientLogin = null;
    }

    private LoginContext systemLogin(String username) throws LoginException {
        if (this.systemLogin != null) {
            HashSet<SystemID> principals = new HashSet<SystemID>();
            SystemID sysId = new SystemID(username);
            principals.add(sysId);
            Subject subject = new Subject(false, principals, new HashSet(), new HashSet());
            return this.systemLogin.login(subject, new CredentialsCallbackHandler(sysId.getName(), sysId));
        }
        return null;
    }

    @Override
    public LoginContext login() throws LoginException {
        return this.loginAs(null);
    }

    @Override
    public LoginContext loginAs(final String username) throws LoginException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<LoginContext>(){

                @Override
                public LoginContext run() throws LoginException {
                    SecurityManager sm = System.getSecurityManager();
                    if (sm != null) {
                        sm.checkPermission(new SystemLoginPermission());
                    }
                    return LoginComponent.this.systemLogin(username);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (LoginException)e.getException();
        }
    }

    @Override
    public LoginContext login(String username, Object credentials) throws LoginException {
        if (this.clientLogin != null) {
            return this.clientLogin.login(username, credentials);
        }
        return null;
    }

    @Override
    public LoginContext login(CallbackHandler cbHandler) throws LoginException {
        if (this.clientLogin != null) {
            return this.clientLogin.login(cbHandler);
        }
        return null;
    }

    @Override
    public boolean isSystemId(Principal principal) {
        return LoginComponent.isSystemLogin(principal);
    }

    public static boolean isSystemLogin(Object principal) {
        if (principal != null && principal.getClass() == SystemID.class) {
            if (!systemLoginManager.isRemoteSystemLoginRestricted()) {
                return true;
            }
            SystemID sys = (SystemID)principal;
            String sourceInstanceId = sys.getSourceInstanceId();
            if (sourceInstanceId == null) {
                log.warn((Object)"Can not accept a system login without InstanceID of the source : System login is rejected");
                return false;
            }
            if (sourceInstanceId.equals(instanceId)) {
                return true;
            }
            if (systemLoginManager.isRemoveSystemLoginAllowedForInstance(sourceInstanceId)) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Remote SystemLogin from instance " + sourceInstanceId + " accepted"));
                }
                return true;
            }
            log.warn((Object)("Remote SystemLogin attempt from instance " + sourceInstanceId + " was denied"));
            return false;
        }
        return false;
    }

    public static class SystemID
    implements Principal,
    Serializable {
        private static final long serialVersionUID = 2758247997191809993L;
        private final String userName;
        protected final String sourceInstanceId = instanceId;

        public SystemID() {
            this.userName = null;
        }

        public SystemID(String origUser) {
            this.userName = origUser == null ? LoginComponent.SYSTEM_USERNAME : origUser;
        }

        @Override
        public String getName() {
            return this.userName;
        }

        public String getSourceInstanceId() {
            return this.sourceInstanceId;
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof Principal) {
                Principal oPal = (Principal)other;
                String oName = oPal.getName();
                if (this.userName == null && oName != null) {
                    return false;
                }
                if (!this.userName.equals(oName)) {
                    return false;
                }
                if (systemLoginManager.isRemoteSystemLoginRestricted() && other instanceof SystemID) {
                    String oSysId = ((SystemID)other).sourceInstanceId;
                    if (this.sourceInstanceId == null) {
                        return oSysId == null;
                    }
                    return this.sourceInstanceId.equals(oSysId);
                }
                return true;
            }
            return false;
        }

        @Override
        public int hashCode() {
            if (!systemLoginManager.isRemoteSystemLoginRestricted()) {
                return this.userName == null ? 0 : this.userName.hashCode();
            }
            return this.userName == null ? 0 : this.userName.hashCode() + this.sourceInstanceId.hashCode();
        }
    }
}

