/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.services.config;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.logging.DeprecationLogger;
import org.nuxeo.runtime.model.SimpleContributionRegistry;
import org.nuxeo.runtime.services.config.ConfigurationPropertyDescriptor;

public class ConfigurationPropertyRegistry
extends SimpleContributionRegistry<ConfigurationPropertyDescriptor> {
    private static final Log log = LogFactory.getLog(ConfigurationPropertyRegistry.class);
    protected Map<String, String> properties = new HashMap<String, String>();

    @Override
    public String getContributionId(ConfigurationPropertyDescriptor contrib) {
        return contrib.getName();
    }

    @Override
    public void contributionUpdated(String key, ConfigurationPropertyDescriptor contrib, ConfigurationPropertyDescriptor newOrigContrib) {
        String name = contrib.getName();
        if (StringUtils.isEmpty((String)name)) {
            log.error((Object)"Cannot register configuration property with an empty name");
            return;
        }
        if (Framework.getProperties().containsKey(key)) {
            String message = String.format("Property '" + key + "' should now be contributed to extension " + "point 'org.nuxeo.runtime.ConfigurationService', using target 'configuration'", new Object[0]);
            DeprecationLogger.log(message, "7.4");
            Framework.getRuntime().getWarnings().add(message);
        }
        String value = contrib.getValue();
        this.properties.put(name, value);
        log.info((Object)("Registered property with name " + name + " and value " + value));
    }

    @Override
    public void contributionRemoved(String id, ConfigurationPropertyDescriptor origContrib) {
        this.properties.remove(id);
        log.info((Object)("Unregistered property with name " + id));
    }

    @Override
    public ConfigurationPropertyDescriptor clone(ConfigurationPropertyDescriptor orig) {
        return orig.clone();
    }

    @Override
    public void merge(ConfigurationPropertyDescriptor src, ConfigurationPropertyDescriptor dst) {
        dst.merge(src);
    }

    @Override
    public boolean isSupportingMerge() {
        return true;
    }

    public boolean hasProperty(String key) {
        return this.properties.containsKey(key);
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }
}

