/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.services.config;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.services.config.ConfigurationPropertyDescriptor;
import org.nuxeo.runtime.services.config.ConfigurationPropertyRegistry;
import org.nuxeo.runtime.services.config.ConfigurationService;

public class ConfigurationServiceImpl
extends DefaultComponent
implements ConfigurationService {
    protected static final Log log = LogFactory.getLog(ConfigurationServiceImpl.class);
    public static final String CONFIGURATION_EP = "configuration";
    protected ConfigurationPropertyRegistry registry = new ConfigurationPropertyRegistry();

    @Override
    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        if (this.registry.hasProperty(key)) {
            return this.registry.getProperty(key);
        }
        return defaultValue;
    }

    @Override
    public boolean isBooleanPropertyTrue(String key) {
        String value = this.getProperty(key);
        return Boolean.parseBoolean(value);
    }

    @Override
    public boolean isBooleanPropertyFalse(String key) {
        String value = this.getProperty(key);
        if (StringUtils.isBlank((String)value)) {
            return false;
        }
        return !Boolean.parseBoolean(value);
    }

    @Override
    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (CONFIGURATION_EP.equals(extensionPoint)) {
            this.registry.addContribution((ConfigurationPropertyDescriptor)contribution);
        }
    }

    @Override
    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (CONFIGURATION_EP.equals(extensionPoint)) {
            this.registry.removeContribution((ConfigurationPropertyDescriptor)contribution);
        }
    }
}

