/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.locator.factory;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.model.resource.locator.UriLocator;
import ro.isdc.wro.model.resource.locator.factory.UriLocatorFactory;

public abstract class AbstractUriLocatorFactory
implements UriLocatorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractUriLocatorFactory.class);

    public final InputStream locate(String uri) throws IOException {
        UriLocator uriLocator = this.getInstance(uri);
        if (uriLocator == null) {
            throw new WroRuntimeException("No locator is capable of handling uri: " + uri);
        }
        LOG.debug("[OK] locating {} using locator: {}", (Object)uri, (Object)uriLocator.getClass().getSimpleName());
        return new AutoCloseInputStream(uriLocator.locate(uri));
    }
}

