/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.support;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.model.resource.locator.ClasspathUriLocator;
import ro.isdc.wro.model.resource.locator.ServletContextUriLocator;
import ro.isdc.wro.model.resource.locator.UrlUriLocator;
import ro.isdc.wro.util.WroUtil;

public class ImageUrlRewriter {
    private static final Logger LOG = LoggerFactory.getLogger(ImageUrlRewriter.class);
    private static final String ROOT_CONTEXT_PATH = "/";
    private static final String FOLDER_PREFIX = "/..";
    private final RewriterContext context;

    public ImageUrlRewriter(RewriterContext context) {
        Validate.notNull((Object)context);
        Validate.notNull((Object)context.proxyPrefix);
        if (context.contextPath == null) {
            context.setContextPath(ROOT_CONTEXT_PATH);
        }
        this.context = context;
    }

    public String rewrite(String cssUri, String imageUrl) {
        Validate.notNull((Object)cssUri);
        Validate.notNull((Object)imageUrl);
        if (StringUtils.isEmpty((CharSequence)imageUrl)) {
            return imageUrl;
        }
        if (ServletContextUriLocator.isValid(cssUri)) {
            if (ServletContextUriLocator.isValid(imageUrl)) {
                return this.prependContextPath(imageUrl);
            }
            if (ServletContextUriLocator.isProtectedResource(cssUri)) {
                return this.context.proxyPrefix + this.computeNewImageLocation(cssUri, imageUrl);
            }
            String aggregatedPathPrefix = this.computeAggregationPathPrefix(this.context.aggregatedFolderPath);
            LOG.debug("computed aggregatedPathPrefix {}", (Object)aggregatedPathPrefix);
            String newImageLocation = this.computeNewImageLocation(aggregatedPathPrefix + cssUri, imageUrl);
            if (newImageLocation.startsWith(ROOT_CONTEXT_PATH)) {
                newImageLocation = this.prependContextPath(newImageLocation);
            }
            LOG.debug("newImageLocation: {}", (Object)newImageLocation);
            return newImageLocation;
        }
        if (UrlUriLocator.isValid(cssUri)) {
            String computedCssUri = ServletContextUriLocator.isValid(imageUrl) ? this.computeCssUriForExternalServer(cssUri) : cssUri;
            return this.computeNewImageLocation(computedCssUri, imageUrl);
        }
        if (ClasspathUriLocator.isValid(cssUri)) {
            String proxyUrl = this.context.proxyPrefix + this.computeNewImageLocation(cssUri, imageUrl);
            String contextRelativeUrl = this.prependContextPath(imageUrl);
            return ServletContextUriLocator.isValid(imageUrl) ? contextRelativeUrl : proxyUrl;
        }
        throw new WroRuntimeException("Could not replace imageUrl: " + imageUrl + ", contained at location: " + cssUri);
    }

    private String prependContextPath(String imageUrl) {
        String contextRelativeUrl = this.context.contextPath.endsWith(ROOT_CONTEXT_PATH) ? imageUrl : this.context.contextPath + imageUrl;
        return contextRelativeUrl;
    }

    private String computeAggregationPathPrefix(String aggregatedFolderPath) {
        LOG.debug("aggregatedFolderPath: {}", (Object)aggregatedFolderPath);
        String computedPrefix = "";
        if (aggregatedFolderPath != null) {
            StringBuffer result = new StringBuffer("");
            Object[] depthFolders = WroUtil.normalize(aggregatedFolderPath).split(ROOT_CONTEXT_PATH);
            LOG.debug("subfolders {}", (Object)Arrays.toString(depthFolders));
            for (Object folder : depthFolders) {
                if (StringUtils.isEmpty((CharSequence)folder)) continue;
                result.append(FOLDER_PREFIX);
            }
            computedPrefix = result.toString().replaceFirst(ROOT_CONTEXT_PATH, "");
        }
        LOG.debug("computedPrefix: {}", (Object)computedPrefix);
        return computedPrefix;
    }

    private String computeCssUriForExternalServer(String cssUri) {
        String exernalServerCssUri = cssUri;
        try {
            String serverHost = cssUri.replace(new URL(cssUri).getPath(), "");
            exernalServerCssUri = serverHost + ROOT_CONTEXT_PATH;
            LOG.debug("using {} host as cssUri", (Object)exernalServerCssUri);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return exernalServerCssUri;
    }

    private String computeNewImageLocation(String cssUri, String imageUrl) {
        LOG.debug("cssUri: {}, imageUrl {}", (Object)cssUri, (Object)imageUrl);
        String cleanImageUrl = WroUtil.cleanImageUrl(imageUrl);
        int idxLastSeparator = cssUri.lastIndexOf(ROOT_CONTEXT_PATH);
        if (idxLastSeparator == -1) {
            if (ClasspathUriLocator.isValid(cssUri) && (idxLastSeparator = cssUri.lastIndexOf(ClasspathUriLocator.PREFIX)) >= 0) {
                idxLastSeparator += ClasspathUriLocator.PREFIX.length() - 1;
            }
            if (idxLastSeparator < 0) {
                throw new IllegalStateException("Invalid cssUri: " + cssUri + ". Should contain at least one '/' character!");
            }
        }
        String cssUriFolder = cssUri.substring(0, idxLastSeparator + 1);
        String processedImageUrl = cleanImageUrl.startsWith(ROOT_CONTEXT_PATH) ? cleanImageUrl.substring(1) : cleanImageUrl;
        String computedImageLocation = ro.isdc.wro.util.StringUtils.cleanPath(cssUriFolder + processedImageUrl);
        LOG.debug("computedImageLocation: {}", (Object)computedImageLocation);
        return computedImageLocation;
    }

    public static final class RewriterContext {
        private String proxyPrefix;
        private String aggregatedFolderPath;
        private String contextPath;

        public RewriterContext setProxyPrefix(String proxyPrefix) {
            this.proxyPrefix = proxyPrefix;
            return this;
        }

        public RewriterContext setAggregatedFolderPath(String aggregatedFolderPath) {
            this.aggregatedFolderPath = aggregatedFolderPath;
            return this;
        }

        public RewriterContext setContextPath(String contextPath) {
            this.contextPath = contextPath;
            return this;
        }
    }
}

