/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.support;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.group.processor.Injector;
import ro.isdc.wro.model.resource.support.AbstractConfigurableStrategySupport;
import ro.isdc.wro.util.DestroyableLazyInitializer;
import ro.isdc.wro.util.LazyInitializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConfigurableSingleStrategy<S, P>
extends AbstractConfigurableStrategySupport<S, P> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractConfigurableSingleStrategy.class);
    @Inject
    private Injector injector;
    private final LazyInitializer<S> lazyInitializer = new DestroyableLazyInitializer<S>(){

        @Override
        protected S initialize() {
            String alias = AbstractConfigurableSingleStrategy.this.getConfiguredValue();
            Object configuredStrategy = AbstractConfigurableSingleStrategy.this.getDefaultStrategy();
            if (!StringUtils.isEmpty((CharSequence)alias)) {
                LOG.debug("configured alias: {}", (Object)alias);
                configuredStrategy = AbstractConfigurableSingleStrategy.this.getStrategyForAlias(alias);
                if (configuredStrategy == null) {
                    throw new WroRuntimeException("Invalid strategy alias provided: <" + alias + ">. Available aliases are: " + AbstractConfigurableSingleStrategy.this.getAvailableAliases());
                }
            }
            if (AbstractConfigurableSingleStrategy.this.injector != null) {
                AbstractConfigurableSingleStrategy.this.injector.inject(configuredStrategy);
            }
            LOG.debug("using strategy: {}", configuredStrategy);
            return configuredStrategy;
        }
    };

    public final S getConfiguredStrategy() {
        return this.lazyInitializer.get();
    }

    protected abstract S getDefaultStrategy();
}

