/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.externalblob;

import java.io.File;
import java.io.IOException;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.externalblob.AbstractExternalBlobAdapter;

public class FileSystemExternalBlobAdapter
extends AbstractExternalBlobAdapter {
    private static final long serialVersionUID = 1L;
    public static final String CONTAINER_PROPERTY_NAME = "container";

    public String getFileAbsolutePath(String localPath) throws PropertyException {
        String container = this.getProperty(CONTAINER_PROPERTY_NAME);
        if (container == null) {
            throw new PropertyException(String.format("External blob adapter with prefix '%s' and class '%s' is missing the '%s' property", this.getPrefix(), this.getClass().getName(), CONTAINER_PROPERTY_NAME));
        }
        if (!(container = container.trim()).endsWith(File.separator)) {
            return String.format("%s%s%s", container, File.separator, localPath);
        }
        return String.format("%s%s", container, localPath);
    }

    @Override
    public Blob getBlob(String uri) throws PropertyException, IOException {
        String localPath = this.getLocalName(uri);
        String path = this.getFileAbsolutePath(localPath);
        File file = new File(path);
        if (!file.exists()) {
            throw new PropertyException(String.format("Cannot find file at '%s'", path));
        }
        Blob blob = Blobs.createBlob(file);
        blob.setFilename(file.getName());
        return blob;
    }
}

