/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.impl.blob;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CloseableFile;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractBlob
implements Blob,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String UTF_8 = "UTF-8";
    public static final String TEXT_PLAIN = "text/plain";
    protected String mimeType;
    protected String encoding;
    protected String filename;
    protected String digest;

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getDigestAlgorithm() {
        return null;
    }

    @Override
    public String getDigest() {
        return this.digest;
    }

    @Override
    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    @Override
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Override
    public void setDigest(String digest) {
        this.digest = digest;
    }

    @Override
    public File getFile() {
        return null;
    }

    @Override
    public byte[] getByteArray() throws IOException {
        try (InputStream in = this.getStream();){
            byte[] byArray = IOUtils.toByteArray((InputStream)in);
            return byArray;
        }
    }

    @Override
    public String getString() throws IOException {
        try (InputStreamReader reader = new InputStreamReader(this.getStream(), this.getEncoding() == null ? UTF_8 : this.getEncoding());){
            String string = IOUtils.toString((Reader)reader);
            return string;
        }
    }

    @Override
    public long getLength() {
        return -1L;
    }

    @Override
    public CloseableFile getCloseableFile() throws IOException {
        return this.getCloseableFile(null);
    }

    @Override
    public CloseableFile getCloseableFile(String ext) throws IOException {
        File file = this.getFile();
        if (file != null && (ext == null || file.getName().endsWith(ext))) {
            return new CloseableFile(file, false);
        }
        File tmp = Framework.createTempFile((String)"nxblob-", (String)ext);
        tmp.delete();
        if (file != null) {
            try {
                Files.createSymbolicLink(tmp.toPath(), file.toPath().toAbsolutePath(), new FileAttribute[0]);
            }
            catch (IOException | UnsupportedOperationException e) {
                Files.copy(file.toPath(), tmp.toPath(), new CopyOption[0]);
            }
        } else {
            try (InputStream in = this.getStream();){
                Files.copy(in, tmp.toPath(), new CopyOption[0]);
            }
        }
        Framework.trackFile((File)tmp, (Object)tmp);
        return new CloseableFile(tmp, true);
    }

    @Override
    public void transferTo(OutputStream out) throws IOException {
        try (InputStream in = this.getStream();){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
    }

    @Override
    public void transferTo(File file) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            this.transferTo(out);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Blob)) {
            return false;
        }
        Blob other = (Blob)object;
        if (!ObjectUtils.equals((Object)this.getFilename(), (Object)other.getFilename())) {
            return false;
        }
        if (!ObjectUtils.equals((Object)this.getMimeType(), (Object)other.getMimeType())) {
            return false;
        }
        if (!ObjectUtils.equals((Object)this.getEncoding(), (Object)other.getEncoding())) {
            return false;
        }
        String digest = this.getDigest();
        String otherDigest = other.getDigest();
        if (digest != null && otherDigest != null && !digest.equals(otherDigest)) {
            return false;
        }
        return this.equalsStream(other);
    }

    protected boolean equalsStream(Blob other) {
        InputStream is = null;
        InputStream ois = null;
        try {
            is = this.getStream();
            ois = other.getStream();
            boolean bl = IOUtils.contentEquals((InputStream)is, (InputStream)ois);
            return bl;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
            IOUtils.closeQuietly((InputStream)ois);
        }
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getFilename()).append((Object)this.getMimeType()).append((Object)this.getEncoding()).toHashCode();
    }
}

