/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.impl.blob;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.IOUtils;
import org.nuxeo.ecm.core.api.impl.blob.AbstractBlob;
import org.nuxeo.runtime.api.Framework;

public class FileBlob
extends AbstractBlob
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected File file;
    protected boolean isTemporary;

    public FileBlob(File file) {
        this(file, null, null, null, null);
    }

    public FileBlob(File file, String mimeType) {
        this(file, mimeType, null, null, null);
    }

    public FileBlob(File file, String mimeType, String encoding) {
        this(file, mimeType, encoding, null, null);
    }

    public FileBlob(File file, String mimeType, String encoding, String filename, String digest) {
        if (file == null) {
            throw new NullPointerException("null file");
        }
        this.file = file;
        this.mimeType = mimeType;
        this.encoding = encoding;
        this.digest = digest;
        this.filename = filename != null ? filename : file.getName();
    }

    public FileBlob(InputStream in) throws IOException {
        this(in, null, null);
    }

    public FileBlob(InputStream in, String mimeType) throws IOException {
        this(in, mimeType, null);
    }

    public FileBlob(InputStream in, String mimeType, String encoding) throws IOException {
        this(in, mimeType, encoding, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileBlob(InputStream in, String mimeType, String encoding, File tmpDir) throws IOException {
        if (in == null) {
            throw new NullPointerException("null inputstream");
        }
        this.mimeType = mimeType;
        this.encoding = encoding;
        this.isTemporary = true;
        try {
            this.file = File.createTempFile("nxblob-", ".tmp", tmpDir);
            Framework.trackFile((File)this.file, (Object)this.file);
            this.filename = this.file.getName();
            try (FileOutputStream out = new FileOutputStream(this.file);){
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public FileBlob(String ext) throws IOException {
        this.isTemporary = true;
        this.file = Framework.createTempFile((String)"nxblob-", (String)ext);
        Framework.trackFile((File)this.file, (Object)this.file);
        this.filename = this.file.getName();
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public long getLength() {
        return this.file.length();
    }

    @Override
    public InputStream getStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public boolean isTemporary() {
        return this.isTemporary;
    }

    public void moveTo(File dest) throws IOException {
        if (!this.isTemporary) {
            throw new IOException("Cannot move non-temporary file: " + this.file);
        }
        Path path = this.file.toPath();
        Path destPath = dest.toPath();
        try {
            Files.move(path, destPath, StandardCopyOption.ATOMIC_MOVE);
            this.file = dest;
        }
        catch (AtomicMoveNotSupportedException e) {
            Path tmp = Files.createTempFile(destPath.getParent(), null, null, new FileAttribute[0]);
            try {
                Files.copy(path, tmp, StandardCopyOption.REPLACE_EXISTING);
                Files.delete(path);
                Files.move(tmp, destPath, StandardCopyOption.ATOMIC_MOVE);
                this.file = dest;
            }
            catch (IOException ioe) {
                Files.deleteIfExists(tmp);
                throw ioe;
            }
        }
        this.isTemporary = false;
    }
}

