/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.local;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.transaction.Synchronization;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.AbstractSession;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.local.LocalException;
import org.nuxeo.ecm.core.api.local.SessionInfo;
import org.nuxeo.ecm.core.model.Session;
import org.nuxeo.ecm.core.repository.RepositoryService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class LocalSession
extends AbstractSession
implements Synchronization {
    private static final long serialVersionUID = 1L;
    private static final AtomicLong SID_COUNTER = new AtomicLong();
    private static final Log log = LogFactory.getLog(LocalSession.class);
    protected String repositoryName;
    protected NuxeoPrincipal principal;
    private String sessionId;
    private final ThreadLocal<SessionInfo> sessionHolder = new ThreadLocal();
    private final Set<SessionInfo> allSessions = Collections.newSetFromMap(new ConcurrentHashMap());

    public static CoreSession createInstance() {
        return new LocalSession();
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void connect(String repositoryName, NuxeoPrincipal principal) {
        if (this.sessionId != null) {
            throw new LocalException("CoreSession already connected");
        }
        this.repositoryName = repositoryName;
        this.principal = principal;
        this.createMetrics();
        this.sessionId = LocalSession.newSessionId(repositoryName, principal);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating CoreSession: " + this.sessionId));
        }
        this.createSession();
    }

    protected static String newSessionId(String repositoryName, NuxeoPrincipal principal) {
        return repositoryName + '/' + principal.getName() + '#' + SID_COUNTER.incrementAndGet();
    }

    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public Session getSession() {
        SessionInfo si = this.sessionHolder.get();
        if (si == null || !si.session.isLive()) {
            this.closeInThisThread();
            if (!TransactionHelper.isTransactionActive()) {
                throw new LocalException("No transaction active, cannot reconnect: " + this.sessionId);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Reconnecting CoreSession: " + this.sessionId));
            }
            si = this.createSession();
        }
        return si.session;
    }

    protected SessionInfo createSession() {
        RepositoryService repositoryService = (RepositoryService)((Object)Framework.getLocalService(RepositoryService.class));
        Session session = repositoryService.getSession(this.repositoryName);
        TransactionHelper.registerSynchronization((Synchronization)this);
        SessionInfo si = new SessionInfo(session);
        this.sessionHolder.set(si);
        this.allSessions.add(si);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding thread " + Thread.currentThread().getName() + " for CoreSession: " + this.sessionId));
        }
        return si;
    }

    public boolean isLive(boolean onThread) {
        if (!onThread) {
            return !this.allSessions.isEmpty();
        }
        return this.sessionHolder.get() != null;
    }

    public void close() {
        CoreInstance.closeCoreSession((CoreSession)this);
    }

    public void beforeCompletion() {
        this.closeInThisThread();
    }

    public void afterCompletion(int status) {
    }

    protected void closeInThisThread() {
        SessionInfo si = this.sessionHolder.get();
        if (si == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing thread " + Thread.currentThread().getName() + " for CoreSession: " + this.sessionId));
        }
        try {
            si.session.close();
        }
        finally {
            this.sessionHolder.remove();
            this.allSessions.remove(si);
        }
    }

    public void destroy() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Destroying CoreSession: " + this.sessionId));
        }
        this.closeInThisThread();
    }

    public NuxeoPrincipal getPrincipal() {
        return this.principal;
    }

    public boolean isStateSharedByAllThreadSessions() {
        return this.getSession().isStateSharedByAllThreadSessions();
    }
}

