/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.ecm.core.blob.binary.BinaryManagerStatus;
import org.nuxeo.ecm.core.model.Document;

public interface BlobManager {
    public BlobProvider getBlobProvider(String var1);

    public BlobProvider getBlobProvider(Blob var1);

    public Blob readBlob(BlobInfo var1, String var2) throws IOException;

    public String writeBlob(Blob var1, Document var2) throws IOException;

    public InputStream getStream(Blob var1) throws IOException;

    public InputStream getThumbnail(Blob var1) throws IOException;

    public URI getURI(Blob var1, UsageHint var2, HttpServletRequest var3) throws IOException;

    public Map<String, URI> getAvailableConversions(Blob var1, UsageHint var2) throws IOException;

    public InputStream getConvertedStream(Blob var1, String var2, DocumentModel var3) throws IOException;

    public Map<String, BlobProvider> getBlobProviders();

    public void freezeVersion(Document var1);

    public void notifyChanges(Document var1, Set<String> var2);

    public BinaryManagerStatus garbageCollectBinaries(boolean var1);

    public boolean isBinariesGarbageCollectionInProgress();

    public void markReferencedBinary(String var1, String var2);

    public static enum UsageHint {
        STREAM,
        DOWNLOAD,
        VIEW,
        EDIT,
        EMBED;

    }

    public static class BlobInfo {
        public String key;
        public String mimeType;
        public String encoding;
        public String filename;
        public Long length;
        public String digest;

        public BlobInfo() {
        }

        public BlobInfo(BlobInfo other) {
            this.key = other.key;
            this.mimeType = other.mimeType;
            this.encoding = other.encoding;
            this.filename = other.filename;
            this.length = other.length;
            this.digest = other.digest;
        }
    }
}

