/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import java.io.IOException;
import java.io.InputStream;
import org.nuxeo.ecm.core.api.impl.blob.AbstractBlob;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.runtime.api.Framework;

public class SimpleManagedBlob
extends AbstractBlob
implements ManagedBlob {
    private static final long serialVersionUID = 1L;
    public final String key;
    public Long length;

    public SimpleManagedBlob(BlobManager.BlobInfo blobInfo) {
        this.key = blobInfo.key;
        this.setMimeType(blobInfo.mimeType);
        this.setEncoding(blobInfo.encoding);
        this.setFilename(blobInfo.filename);
        this.setDigest(blobInfo.digest);
        this.length = blobInfo.length;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getProviderId() {
        int colon = this.key.indexOf(58);
        if (colon < 0) {
            throw new IllegalArgumentException("Invalid managed blob key: " + this.key);
        }
        return this.key.substring(0, colon);
    }

    public InputStream getStream() throws IOException {
        return ((BlobManager)Framework.getService(BlobManager.class)).getStream(this);
    }

    public long getLength() {
        return this.length == null ? -1L : this.length;
    }
}

