/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.directory.BaseDirectoryDescriptor;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;

public class DirectoryRegistry {
    private static final Log log = LogFactory.getLog(DirectoryRegistry.class);
    protected Map<String, List<BaseDirectoryDescriptor>> allDescriptors = new HashMap<String, List<BaseDirectoryDescriptor>>();
    protected Map<String, Set<String>> descriptorsForTemplates = new HashMap<String, Set<String>>();
    protected Map<String, BaseDirectoryDescriptor> descriptors = new HashMap<String, BaseDirectoryDescriptor>();
    protected Map<String, Directory> directories = new HashMap<String, Directory>();

    public synchronized void addContribution(BaseDirectoryDescriptor contrib) {
        String id = contrib.name;
        log.info((Object)("Registered directory" + (contrib.template ? " template" : "") + ": " + id));
        this.allDescriptors.computeIfAbsent(id, k -> new ArrayList()).add(contrib);
        this.contributionChanged(contrib);
    }

    public synchronized void removeContribution(BaseDirectoryDescriptor contrib) {
        String id = contrib.name;
        log.info((Object)("Unregistered directory" + (contrib.template ? " template" : "") + ": " + id));
        this.allDescriptors.getOrDefault(id, Collections.emptyList()).remove(contrib);
        this.contributionChanged(contrib);
    }

    protected void contributionChanged(BaseDirectoryDescriptor contrib) {
        String id = contrib.name;
        if (contrib.template) {
            this.removeDirectory(id);
            this.recomputeDescriptor(id);
            Set ids = this.descriptorsForTemplates.getOrDefault(id, Collections.emptySet());
            for (String did : ids) {
                this.recomputeDescriptor(did);
            }
        } else {
            this.recomputeDescriptor(id);
        }
    }

    protected void removeDirectory(String id) {
        Directory dir = this.directories.remove(id);
        if (dir != null) {
            DirectoryRegistry.shutdownDirectory(dir);
        }
    }

    protected void recomputeDescriptor(String id) {
        this.removeDirectory(id);
        List list = this.allDescriptors.getOrDefault(id, Collections.emptyList());
        Object contrib = null;
        for (BaseDirectoryDescriptor next : list) {
            if (next.extendz != null) {
                BaseDirectoryDescriptor base = this.descriptors.get(next.extendz);
                if (base != null && base.template) {
                    contrib = base.clone();
                    ((BaseDirectoryDescriptor)contrib).template = false;
                    ((BaseDirectoryDescriptor)contrib).name = next.name;
                    contrib.merge(next);
                } else {
                    log.debug((Object)("Directory " + id + " extends non-existing directory template: " + next.extendz));
                    contrib = null;
                }
                this.descriptorsForTemplates.computeIfAbsent(next.extendz, k -> new HashSet()).add(id);
                continue;
            }
            if (next.remove) {
                contrib = null;
                continue;
            }
            if (contrib == null) {
                contrib = next.clone();
                continue;
            }
            if (contrib.getClass() == next.getClass()) {
                contrib.merge(next);
                continue;
            }
            log.warn((Object)("Directory " + id + " redefined with different factory"));
            contrib = next.clone();
        }
        if (contrib == null) {
            this.descriptors.remove(id);
        } else {
            this.descriptors.put(id, (BaseDirectoryDescriptor)contrib);
        }
    }

    public synchronized BaseDirectoryDescriptor getDirectoryDescriptor(String id) {
        return this.descriptors.get(id);
    }

    public synchronized Directory getDirectory(String id) {
        BaseDirectoryDescriptor descriptor;
        Directory dir = this.directories.get(id);
        if (dir == null && (descriptor = this.descriptors.get(id)) != null) {
            dir = descriptor.newDirectory();
            this.directories.put(id, dir);
        }
        return dir;
    }

    public synchronized List<String> getDirectoryIds() {
        ArrayList<String> list = new ArrayList<String>();
        for (BaseDirectoryDescriptor descriptor : this.descriptors.values()) {
            if (descriptor.template) continue;
            list.add(descriptor.name);
        }
        return list;
    }

    public synchronized List<Directory> getDirectories() {
        ArrayList<Directory> list = new ArrayList<Directory>();
        for (BaseDirectoryDescriptor descriptor : this.descriptors.values()) {
            if (descriptor.template) continue;
            list.add(this.getDirectory(descriptor.name));
        }
        return list;
    }

    public synchronized void shutdown() {
        for (Directory dir : this.directories.values()) {
            DirectoryRegistry.shutdownDirectory(dir);
        }
        this.allDescriptors.clear();
        this.descriptorsForTemplates.clear();
        this.descriptors.clear();
        this.directories.clear();
    }

    protected static void shutdownDirectory(Directory dir) {
        try {
            dir.shutdown();
        }
        catch (DirectoryException e) {
            log.error((Object)("Error while shutting down directory:" + dir.getName()), (Throwable)e);
        }
    }
}

