/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.deployment.preprocessor.template;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.TextTemplate;
import org.nuxeo.runtime.deployment.preprocessor.template.TemplateContribution;

public class Template {
    private static final Log log = LogFactory.getLog(Template.class);
    public static final String BEGIN = "BEGIN";
    public static final String END = "END";
    protected static final String JBOSS5_COMPAT = "org.nuxeo.runtme.preprocessing.jboss5";
    final LinkedHashMap<String, Part> parts = new LinkedHashMap();
    protected boolean runningOnJBoss5 = false;
    protected static final Pattern JAVA_MODULE = Pattern.compile("<\\s*module\\s*>\\s*<\\s*java\\s*>.+<\\s*/\\s*java\\s*>\\s*<\\s*/\\s*module\\s*>");

    public Template() {
        String v = System.getProperty(JBOSS5_COMPAT);
        if (v != null) {
            this.runningOnJBoss5 = Boolean.parseBoolean(v);
        }
    }

    public void addPart(String name, String text) {
        this.parts.put(name, new Part(name, text));
    }

    public void update(TemplateContribution tc, Map<String, String> ctx) {
        String content = this.getContent(tc, ctx);
        content = new TextTemplate(ctx).processText(content);
        if (tc.isAppending()) {
            this.appendText(tc.getMarker(), content);
        } else if (tc.isPrepending()) {
            this.prependText(tc.getMarker(), content);
        } else if (tc.isReplacing()) {
            this.replaceText(tc.getMarker(), content);
        }
    }

    public void appendText(String marker, String text) {
        Part part = this.parts.get(marker);
        if (part != null) {
            part.append(text);
        } else {
            log.debug((Object)("Could not find marker: " + marker));
        }
    }

    public void prependText(String marker, String text) {
        Part part = this.parts.get(marker);
        if (part != null) {
            part.prepend(text);
        } else {
            log.debug((Object)("Could not find marker: " + marker));
        }
    }

    public void replaceText(String marker, String text) {
        Part part = this.parts.get(marker);
        if (part != null) {
            part.replace(text);
        } else {
            log.debug((Object)("Could not find marker: " + marker));
        }
    }

    public String getText() {
        StringBuilder buf = new StringBuilder();
        for (Part part : this.parts.values()) {
            buf.append(part.text);
        }
        return buf.toString();
    }

    protected String getContent(TemplateContribution tc, Map<String, String> context) {
        String content = tc.getContent();
        if (this.runningOnJBoss5 && "application".equals(tc.getTemplate()) && "MODULE".equals(tc.getMarker())) {
            String oldcontent = content;
            if (oldcontent != (content = Template.removeJavaModules(content))) {
                log.warn((Object)("The deployment-fragment contains illegal JEE java module contribution: " + context.get("bundle.shortName")));
            }
            if (content.length() == 0) {
                return "";
            }
        }
        return "\n" + content.trim() + "\n";
    }

    protected static String removeJavaModules(String content) {
        Matcher m = JAVA_MODULE.matcher(content);
        if (m.find()) {
            return m.replaceAll("").trim();
        }
        return content;
    }

    static class Part {
        public final String name;
        public final StringBuffer text;
        public final int offset;

        Part(String name, String text) {
            this.name = name;
            this.text = text == null ? new StringBuffer() : new StringBuffer(text);
            this.offset = this.text.length();
        }

        public void append(String aText) {
            this.text.append(aText);
        }

        public void prepend(String aText) {
            this.text.insert(this.offset, aText);
        }

        public void replace(String aText) {
            this.text.replace(this.offset, this.text.length(), aText);
        }

        public String getText() {
            return this.text.toString();
        }

        public String getName() {
            return this.name;
        }
    }
}

