/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.tokenauth.io;

import java.io.IOException;
import org.codehaus.jackson.JsonGenerator;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.nuxeo.ecm.core.io.marshallers.json.AbstractJsonWriter;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.tokenauth.io.AuthenticationToken;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class AuthenticationTokenWriter
extends AbstractJsonWriter<AuthenticationToken> {
    public static final String ENTITY_TYPE = "token";

    public void write(AuthenticationToken token, JsonGenerator jg) throws IOException {
        jg.writeStartObject();
        jg.writeStringField("entity-type", ENTITY_TYPE);
        jg.writeStringField("id", token.getToken());
        jg.writeStringField("username", token.getUserName());
        jg.writeStringField("application", token.getApplicationName());
        jg.writeStringField("deviceId", token.getDeviceId());
        jg.writeStringField("deviceDescription", token.getDeviceDescription());
        jg.writeStringField("permission", token.getPermission());
        DateTimeFormatter dateTime = ISODateTimeFormat.dateTime();
        jg.writeStringField("creationDate", dateTime.print((ReadableInstant)new DateTime((Object)token.getCreationDate())));
        jg.writeEndObject();
    }
}

