/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.request;

import java.io.IOException;
import java.io.InputStream;
import org.richfaces.exception.FileUploadException;
import org.richfaces.model.UploadedFile;
import org.richfaces.util.StreamUtils;

public abstract class BaseUploadedFile
implements UploadedFile {
    private String parameterName;

    public BaseUploadedFile(String parameterName) {
        this.parameterName = parameterName;
    }

    @Override
    public String getParameterName() {
        return this.parameterName;
    }

    @Override
    public String getName() {
        return this.getHeader("filename");
    }

    @Override
    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    @Override
    public byte[] getData() {
        long size = this.getSize();
        if (size > Integer.MAX_VALUE) {
            throw new FileUploadException("Resource content is too long to be allocated as byte[]");
        }
        InputStream is = null;
        try {
            is = this.getInputStream();
            byte[] byArray = StreamUtils.toByteArray((InputStream)is);
            return byArray;
        }
        catch (IOException e) {
            throw new FileUploadException(e.getMessage(), e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {}
        }
    }

    @Override
    public String getFileExtension() {
        int i;
        String name = this.getName();
        if (name != null && (i = name.lastIndexOf(46)) > 0) {
            return name.substring(i + 1);
        }
        return "";
    }
}

