/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.coremodel;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.storage.DefaultFulltextParser;
import org.nuxeo.ecm.core.storage.FulltextExtractorWork;
import org.nuxeo.ecm.core.storage.FulltextParser;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLRepositoryService;
import org.nuxeo.runtime.api.Framework;

public class SQLFulltextExtractorWork
extends FulltextExtractorWork {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(SQLFulltextExtractorWork.class);

    public SQLFulltextExtractorWork(String repositoryName, String docId) {
        super(repositoryName, docId, repositoryName + ':' + docId + ":sqlFulltextExtractor", true);
    }

    public void initFulltextConfigurationAndParser() {
        SQLRepositoryService sqlRepositoryService = (SQLRepositoryService)((Object)Framework.getService(SQLRepositoryService.class));
        this.fulltextConfiguration = sqlRepositoryService.getFulltextConfiguration(this.repositoryName);
        Class<? extends FulltextParser> fulltextParserClass = sqlRepositoryService.getFulltextParserClass(this.repositoryName);
        this.fulltextParser = new DefaultFulltextParser();
        if (fulltextParserClass != null) {
            try {
                this.fulltextParser = fulltextParserClass.newInstance();
            }
            catch (InstantiationException e) {
                log.error((Object)("Failed to instantiate " + fulltextParserClass.getCanonicalName()), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)("Failed to instantiate " + fulltextParserClass.getCanonicalName()), (Throwable)e);
            }
        }
    }
}

