/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCMapper;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.SQLStatement;

public class TableUpgrader {
    protected List<TableUpgrade> tableUpgrades = new ArrayList<TableUpgrade>();
    private JDBCMapper mapper;
    private static final Log log = LogFactory.getLog(TableUpgrader.class);

    public TableUpgrader(JDBCMapper mapper) {
        this.mapper = mapper;
    }

    public void add(String tableKey, String columnName, String sqlProcedure, String testProp) {
        this.tableUpgrades.add(new TableUpgrade(tableKey, columnName, sqlProcedure, testProp));
    }

    public void upgrade(String tableKey, List<Column> addedColumns, String ddlMode, SQLStatement.ListCollector ddlCollector) throws SQLException {
        for (TableUpgrade upgrade : this.tableUpgrades) {
            boolean doUpgrade;
            if (!upgrade.tableKey.equals(tableKey)) continue;
            if (addedColumns == null) {
                doUpgrade = JDBCMapper.testProps.containsKey(upgrade.testProp);
            } else {
                doUpgrade = false;
                for (Column col : addedColumns) {
                    if (!col.getKey().equals(upgrade.columnName)) continue;
                    doUpgrade = true;
                    break;
                }
            }
            if (!doUpgrade) continue;
            log.info((Object)("Upgrading table: " + tableKey));
            this.mapper.sqlInfo.executeSQLStatements(upgrade.sqlProcedure, ddlMode, this.mapper.connection, this.mapper.logger, ddlCollector);
        }
    }

    protected static class TableUpgrade {
        public final String tableKey;
        public final String columnName;
        public final String sqlProcedure;
        public final String testProp;

        public TableUpgrade(String tableKey, String columnName, String sqlProcedure, String testProp) {
            this.tableKey = tableKey;
            this.columnName = columnName;
            this.sqlProcedure = sqlProcedure;
            this.testProp = testProp;
        }
    }
}

