/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.service;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.el.ExpressionFactoryImpl;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.event.DeletedDocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.audit.api.ExtendedInfo;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.impl.LogEntryImpl;
import org.nuxeo.ecm.platform.audit.service.AuditBackend;
import org.nuxeo.ecm.platform.audit.service.BaseLogEntryProvider;
import org.nuxeo.ecm.platform.audit.service.NXAuditEventsService;
import org.nuxeo.ecm.platform.audit.service.extension.AdapterDescriptor;
import org.nuxeo.ecm.platform.audit.service.extension.AuditBackendDescriptor;
import org.nuxeo.ecm.platform.audit.service.extension.ExtendedInfoDescriptor;
import org.nuxeo.ecm.platform.el.ExpressionContext;
import org.nuxeo.ecm.platform.el.ExpressionEvaluator;

public abstract class AbstractAuditBackend
implements AuditBackend {
    protected static final Log log = LogFactory.getLog(AbstractAuditBackend.class);
    public static final String FORCE_AUDIT_FACET = "ForceAudit";
    protected final NXAuditEventsService component;
    protected final AuditBackendDescriptor config;
    protected final ExpressionEvaluator expressionEvaluator = new ExpressionEvaluator((ExpressionFactory)new ExpressionFactoryImpl());

    protected AbstractAuditBackend(NXAuditEventsService component, AuditBackendDescriptor config) {
        this.component = component;
        this.config = config;
    }

    protected DocumentModel guardedDocument(CoreSession session, DocumentRef reference) {
        if (session == null) {
            return null;
        }
        if (reference == null) {
            return null;
        }
        try {
            return session.getDocument(reference);
        }
        catch (DocumentNotFoundException e) {
            return null;
        }
    }

    protected DocumentModelList guardedDocumentChildren(CoreSession session, DocumentRef reference) {
        return session.getChildren(reference);
    }

    protected LogEntry doCreateAndFillEntryFromDocument(DocumentModel doc, Principal principal) {
        LogEntry entry = this.newLogEntry();
        entry.setDocPath(doc.getPathAsString());
        entry.setDocType(doc.getType());
        entry.setDocUUID(doc.getId());
        entry.setRepositoryId(doc.getRepositoryName());
        entry.setPrincipalName("system");
        entry.setCategory("eventDocumentCategory");
        entry.setEventId("documentCreated");
        entry.setDocLifeCycle("project");
        Calendar creationDate = (Calendar)doc.getProperty("dublincore", "created");
        if (creationDate != null) {
            entry.setEventDate(creationDate.getTime());
        }
        this.doPutExtendedInfos(entry, null, doc, principal);
        return entry;
    }

    protected void doPutExtendedInfos(LogEntry entry, EventContext eventContext, DocumentModel source, Principal principal) {
        Map map;
        ExpressionContext context = new ExpressionContext();
        if (eventContext != null) {
            this.expressionEvaluator.bindValue((ELContext)context, "message", (Object)eventContext);
        }
        if (source != null) {
            this.expressionEvaluator.bindValue((ELContext)context, "source", (Object)source);
            for (AdapterDescriptor ad : this.component.getDocumentAdapters()) {
                Object adapter;
                if (source instanceof DeletedDocumentModel || (adapter = source.getAdapter(ad.getKlass())) == null) continue;
                this.expressionEvaluator.bindValue((ELContext)context, ad.getName(), adapter);
            }
        }
        if (principal != null) {
            this.expressionEvaluator.bindValue((ELContext)context, "principal", (Object)principal);
        }
        this.populateExtendedInfo(entry, source, context, this.component.getExtendedInfoDescriptors());
        this.populateExtendedInfo(entry, source, context, (Collection<ExtendedInfoDescriptor>)this.component.getEventExtendedInfoDescriptors().get(entry.getEventId()));
        if (eventContext != null && (map = (Map)((Object)eventContext.getProperty("extendedInfos"))) != null) {
            Map extendedInfos = entry.getExtendedInfos();
            for (Map.Entry en : map.entrySet()) {
                Serializable value = (Serializable)en.getValue();
                if (value == null) continue;
                extendedInfos.put(en.getKey(), this.newExtendedInfo(value));
            }
        }
    }

    protected void populateExtendedInfo(LogEntry entry, DocumentModel source, ExpressionContext context, Collection<ExtendedInfoDescriptor> extInfos) {
        if (extInfos != null) {
            Map extendedInfos = entry.getExtendedInfos();
            for (ExtendedInfoDescriptor descriptor : extInfos) {
                String exp = descriptor.getExpression();
                Serializable value = null;
                try {
                    value = (Serializable)this.expressionEvaluator.evaluateExpression((ELContext)context, exp, Serializable.class);
                }
                catch (UnsupportedOperationException | PropertyException e) {
                    if (!(source instanceof DeletedDocumentModel)) continue;
                    log.debug((Object)("Can not evaluate the expression: " + exp + " on a DeletedDocumentModel, skipping."));
                    continue;
                }
                catch (ELException e) {
                    continue;
                }
                if (value == null) continue;
                extendedInfos.put(descriptor.getKey(), this.newExtendedInfo(value));
            }
        }
    }

    public Set<String> getAuditableEventNames() {
        return this.component.getAuditableEventNames();
    }

    protected LogEntry buildEntryFromEvent(Event event) {
        EventContext ctx = event.getContext();
        String eventName = event.getName();
        Date eventDate = new Date(event.getTime());
        LogEntry entry = this.newLogEntry();
        entry.setEventId(eventName);
        entry.setEventDate(eventDate);
        if (ctx instanceof DocumentEventContext) {
            String category;
            DocumentEventContext docCtx = (DocumentEventContext)ctx;
            DocumentModel document = docCtx.getSourceDocument();
            if (document.hasFacet("SystemDocument") && !document.hasFacet(FORCE_AUDIT_FACET)) {
                return null;
            }
            Boolean disabled = (Boolean)docCtx.getProperty("disableAuditLogger");
            if (disabled != null && disabled.booleanValue()) {
                return null;
            }
            Principal principal = docCtx.getPrincipal();
            Map properties = docCtx.getProperties();
            if (document != null) {
                entry.setDocUUID(document.getId());
                entry.setDocPath(document.getPathAsString());
                entry.setDocType(document.getType());
                entry.setRepositoryId(document.getRepositoryName());
            }
            if (principal != null) {
                String principalName = null;
                principalName = principal instanceof NuxeoPrincipal ? ((NuxeoPrincipal)principal).getActingUser() : principal.getName();
                entry.setPrincipalName(principalName);
            } else {
                log.warn((Object)("received event " + eventName + " with null principal"));
            }
            entry.setComment((String)properties.get("comment"));
            if (document instanceof DeletedDocumentModel) {
                entry.setComment("Document does not exist anymore!");
            } else if (document.isLifeCycleLoaded()) {
                entry.setDocLifeCycle(document.getCurrentLifeCycleState());
            }
            if ("lifecycle_transition_event".equals(eventName)) {
                entry.setDocLifeCycle((String)((Object)docCtx.getProperty("to")));
            }
            if ((category = (String)properties.get("category")) != null) {
                entry.setCategory(category);
            } else {
                entry.setCategory("eventDocumentCategory");
            }
            this.doPutExtendedInfos(entry, (EventContext)docCtx, document, principal);
        } else {
            Principal principal = ctx.getPrincipal();
            Map properties = ctx.getProperties();
            if (principal != null) {
                String principalName = principal instanceof NuxeoPrincipal ? ((NuxeoPrincipal)principal).getActingUser() : principal.getName();
                entry.setPrincipalName(principalName);
            }
            entry.setComment((String)properties.get("comment"));
            String category = (String)properties.get("category");
            entry.setCategory(category);
            this.doPutExtendedInfos(entry, ctx, null, principal);
        }
        return entry;
    }

    public List<LogEntry> queryLogsByPage(String[] eventIds, String dateRange, String category, String path, int pageNb, int pageSize) {
        String[] categories = new String[]{category};
        return this.queryLogsByPage(eventIds, dateRange, categories, path, pageNb, pageSize);
    }

    public List<LogEntry> queryLogsByPage(String[] eventIds, Date limit, String category, String path, int pageNb, int pageSize) {
        String[] categories = new String[]{category};
        return this.queryLogsByPage(eventIds, limit, categories, path, pageNb, pageSize);
    }

    public LogEntry newLogEntry() {
        return new LogEntryImpl();
    }

    public abstract ExtendedInfo newExtendedInfo(Serializable var1);

    protected long syncLogCreationEntries(BaseLogEntryProvider provider, String repoId, String path, Boolean recurs) {
        provider.removeEntries("documentCreated", path);
        try (CoreSession session = CoreInstance.openCoreSession((String)repoId);){
            PathRef rootRef = new PathRef(path);
            DocumentModel root = this.guardedDocument(session, (DocumentRef)rootRef);
            long nbAddedEntries = this.doSyncNode(provider, session, root, recurs);
            if (log.isDebugEnabled()) {
                log.debug((Object)("synced " + nbAddedEntries + " entries on " + path));
            }
            long l = nbAddedEntries;
            return l;
        }
    }

    protected long doSyncNode(BaseLogEntryProvider provider, CoreSession session, DocumentModel node, boolean recurs) {
        long nbSyncedEntries = 1L;
        Principal principal = session.getPrincipal();
        ArrayList<DocumentModel> folderishChildren = new ArrayList<DocumentModel>();
        provider.addLogEntry(this.doCreateAndFillEntryFromDocument(node, session.getPrincipal()));
        for (DocumentModel child : this.guardedDocumentChildren(session, node.getRef())) {
            if (child.isFolder() && recurs) {
                folderishChildren.add(child);
                continue;
            }
            provider.addLogEntry(this.doCreateAndFillEntryFromDocument(child, principal));
            ++nbSyncedEntries;
        }
        if (recurs) {
            for (DocumentModel folderChild : folderishChildren) {
                nbSyncedEntries += this.doSyncNode(provider, session, folderChild, recurs);
            }
        }
        return nbSyncedEntries;
    }

    public void logEvents(EventBundle bundle) {
        if (!this.isAuditable(bundle)) {
            return;
        }
        for (Event event : bundle) {
            this.logEvent(event);
        }
    }

    protected boolean isAuditable(EventBundle eventBundle) {
        for (String name : this.getAuditableEventNames()) {
            if (!eventBundle.containsEventName(name)) continue;
            return true;
        }
        return false;
    }

    public void logEvent(Event event) {
        if (!this.getAuditableEventNames().contains(event.getName())) {
            return;
        }
        LogEntry entry = this.buildEntryFromEvent(event);
        if (entry == null) {
            return;
        }
        this.component.bulker.offer(entry);
    }

    public boolean await(long time, TimeUnit unit) throws InterruptedException {
        return this.component.bulker.await(time, unit);
    }

    public List<LogEntry> getLogEntriesFor(String uuid) {
        return this.getLogEntriesFor(uuid, Collections.emptyMap(), false);
    }

    public List<?> nativeQuery(String query, int pageNb, int pageSize) {
        return this.nativeQuery(query, Collections.emptyMap(), pageNb, pageSize);
    }

    public List<LogEntry> queryLogs(String[] eventIds, String dateRange) {
        return this.queryLogsByPage(eventIds, null, null, null, 0, 10000);
    }

    public List<LogEntry> nativeQueryLogs(String whereClause, int pageNb, int pageSize) {
        LinkedList<LogEntry> entries = new LinkedList<LogEntry>();
        for (Object entry : this.nativeQuery(whereClause, pageNb, pageSize)) {
            if (!(entry instanceof LogEntry)) continue;
            entries.add((LogEntry)entry);
        }
        return entries;
    }
}

