/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.audit.api.DocumentHistoryReader;
import org.nuxeo.ecm.platform.audit.api.document.DocumentHistoryReaderImpl;
import org.nuxeo.ecm.platform.audit.service.AuditBackend;
import org.nuxeo.ecm.platform.audit.service.AuditBulker;
import org.nuxeo.ecm.platform.audit.service.extension.AdapterDescriptor;
import org.nuxeo.ecm.platform.audit.service.extension.AuditBackendDescriptor;
import org.nuxeo.ecm.platform.audit.service.extension.AuditBulkerDescriptor;
import org.nuxeo.ecm.platform.audit.service.extension.EventDescriptor;
import org.nuxeo.ecm.platform.audit.service.extension.ExtendedInfoDescriptor;
import org.nuxeo.runtime.RuntimeServiceEvent;
import org.nuxeo.runtime.RuntimeServiceListener;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

public class NXAuditEventsService
extends DefaultComponent {
    public static final ComponentName NAME = new ComponentName("org.nuxeo.ecm.platform.audit.service.NXAuditEventsService");
    private static final String EVENT_EXT_POINT = "event";
    private static final String EXTENDED_INFO_EXT_POINT = "extendedInfo";
    private static final String ADAPTER_POINT = "adapter";
    public static final String DISABLE_AUDIT_LOGGER = "disableAuditLogger";
    private static final String BACKEND_EXT_POINT = "backend";
    protected static final Log log = LogFactory.getLog(NXAuditEventsService.class);
    protected final Set<ExtendedInfoDescriptor> extendedInfoDescriptors = new HashSet<ExtendedInfoDescriptor>();
    protected final Map<String, List<ExtendedInfoDescriptor>> eventExtendedInfoDescriptors = new HashMap<String, List<ExtendedInfoDescriptor>>();
    protected final Set<AdapterDescriptor> documentAdapters = new HashSet<AdapterDescriptor>();
    protected final Set<String> eventNames = new HashSet<String>();
    protected AuditBackend backend;
    protected AuditBackendDescriptor backendConfig = new AuditBackendDescriptor();
    protected AuditBulker bulker;
    protected AuditBulkerDescriptor bulkerConfig = new AuditBulkerDescriptor();

    public int getApplicationStartedOrder() {
        return this.backendConfig.getApplicationStartedOrder();
    }

    public void applicationStarted(ComponentContext context) {
        this.backend = this.backendConfig.newInstance(this);
        this.backend.onApplicationStarted();
        this.bulker = this.bulkerConfig.newInstance(this.backend);
        this.bulker.onApplicationStarted();
        Framework.addListener((RuntimeServiceListener)new RuntimeServiceListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleEvent(RuntimeServiceEvent event) {
                if (event.id != 3) {
                    return;
                }
                Framework.removeListener((RuntimeServiceListener)this);
                try {
                    NXAuditEventsService.this.backend.onShutdown();
                }
                finally {
                    try {
                        NXAuditEventsService.this.bulker.onShutdown();
                    }
                    finally {
                        NXAuditEventsService.this.bulker = null;
                    }
                    NXAuditEventsService.this.backend = null;
                }
            }
        });
    }

    protected void doRegisterAdapter(AdapterDescriptor desc) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registered adapter : " + desc.getName()));
        }
        this.documentAdapters.add(desc);
    }

    protected void doRegisterEvent(EventDescriptor desc) {
        String eventName = desc.getName();
        boolean eventEnabled = desc.getEnabled();
        if (eventEnabled) {
            this.eventNames.add(eventName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Registered event: " + eventName));
            }
            for (ExtendedInfoDescriptor extInfoDesc : desc.getExtendedInfoDescriptors()) {
                if (extInfoDesc.getEnabled()) {
                    if (this.eventExtendedInfoDescriptors.containsKey(eventName)) {
                        this.eventExtendedInfoDescriptors.get(eventName).add(extInfoDesc);
                        continue;
                    }
                    ArrayList<ExtendedInfoDescriptor> toBeAdded = new ArrayList<ExtendedInfoDescriptor>();
                    toBeAdded.add(extInfoDesc);
                    this.eventExtendedInfoDescriptors.put(eventName, toBeAdded);
                    continue;
                }
                if (!this.eventExtendedInfoDescriptors.containsKey(eventName)) continue;
                this.eventExtendedInfoDescriptors.get(eventName).remove(extInfoDesc);
            }
        } else if (this.eventNames.contains(eventName) && !eventEnabled) {
            this.doUnregisterEvent(desc);
        }
    }

    protected void doRegisterExtendedInfo(ExtendedInfoDescriptor desc) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registered extended info mapping : " + desc.getKey()));
        }
        this.extendedInfoDescriptors.add(desc);
    }

    protected void doUnregisterAdapter(AdapterDescriptor desc) {
        this.documentAdapters.remove(desc.getName());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unregistered adapter: " + desc.getName()));
        }
    }

    protected void doUnregisterEvent(EventDescriptor desc) {
        this.eventNames.remove(desc.getName());
        this.eventExtendedInfoDescriptors.remove(desc.getName());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unregistered event: " + desc.getName()));
        }
    }

    protected void doUnregisterExtendedInfo(ExtendedInfoDescriptor desc) {
        this.extendedInfoDescriptors.remove(desc.getKey());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unregistered extended info: " + desc.getKey()));
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.getCanonicalName().equals(DocumentHistoryReader.class.getCanonicalName())) {
            return adapter.cast(new DocumentHistoryReaderImpl());
        }
        if (this.backend != null) {
            return adapter.cast(this.backend);
        }
        log.error((Object)("Can not provide service " + adapter.getCanonicalName() + " since backend is undefined"));
        return null;
    }

    public Set<String> getAuditableEventNames() {
        return this.eventNames;
    }

    public AuditBackend getBackend() {
        return this.backend;
    }

    public Set<AdapterDescriptor> getDocumentAdapters() {
        return this.documentAdapters;
    }

    public Map<String, List<ExtendedInfoDescriptor>> getEventExtendedInfoDescriptors() {
        return this.eventExtendedInfoDescriptors;
    }

    public Set<ExtendedInfoDescriptor> getExtendedInfoDescriptors() {
        return this.extendedInfoDescriptors;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals(EVENT_EXT_POINT)) {
            this.doRegisterEvent((EventDescriptor)contribution);
        } else if (extensionPoint.equals(EXTENDED_INFO_EXT_POINT)) {
            this.doRegisterExtendedInfo((ExtendedInfoDescriptor)contribution);
        } else if (extensionPoint.equals(ADAPTER_POINT)) {
            this.doRegisterAdapter((AdapterDescriptor)contribution);
        } else if (contribution instanceof AuditBackendDescriptor) {
            this.backendConfig = (AuditBackendDescriptor)contribution;
        } else if (contribution instanceof AuditBulkerDescriptor) {
            this.bulkerConfig = (AuditBulkerDescriptor)contribution;
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals(EVENT_EXT_POINT)) {
            this.doUnregisterEvent((EventDescriptor)contribution);
        } else if (extensionPoint.equals(EXTENDED_INFO_EXT_POINT)) {
            this.doUnregisterExtendedInfo((ExtendedInfoDescriptor)contribution);
        } else if (extensionPoint.equals(ADAPTER_POINT)) {
            this.doUnregisterAdapter((AdapterDescriptor)contribution);
        }
    }
}

