/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.url;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.annotations.Begin;
import org.jboss.seam.annotations.In;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.tag.fn.DocumentModelFunctions;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.util.RepositoryLocation;

public abstract class AbstractRenditionRestHelper
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Log log = LogFactory.getLog(AbstractRenditionRestHelper.class);
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(create=true)
    protected Map<String, String> messages;

    protected abstract Blob renderAsBlob(DocumentModel var1, String var2) throws Exception;

    @Begin(id="#{conversationIdGenerator.nextMainConversationId}", join=true)
    public void render(DocumentView docView) throws Exception {
        DocumentModel doc;
        DocumentLocation docLoc = docView.getDocumentLocation();
        if (this.documentManager == null) {
            RepositoryLocation loc = new RepositoryLocation(docLoc.getServerName());
            this.navigationContext.setCurrentServerLocation(loc);
            this.documentManager = this.navigationContext.getOrCreateDocumentManager();
        }
        if ((doc = this.documentManager.getDocument(docLoc.getDocRef())) != null) {
            String renditionName = docView.getParameter("rendition");
            FacesContext context = FacesContext.getCurrentInstance();
            Blob rendered = null;
            try {
                rendered = this.renderAsBlob(doc, renditionName);
            }
            catch (NuxeoException e) {
                log.error((Object)("Unable to generate rendition " + renditionName), (Throwable)e);
                this.facesMessages.add(StatusMessage.Severity.WARN, this.messages.get("rendition.not.available"), new Object[]{renditionName});
                HttpServletRequest req = (HttpServletRequest)context.getExternalContext().getRequest();
                String url = DocumentModelFunctions.documentUrl((DocumentModel)doc, (HttpServletRequest)req);
                HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
                try {
                    response.sendRedirect(url);
                    response.flushBuffer();
                    FacesContext.getCurrentInstance().responseComplete();
                }
                catch (IOException ioe) {
                    log.error((Object)"Error while redirecting to standard view", (Throwable)ioe);
                }
                return;
            }
            if (rendered != null) {
                if (rendered.getMimeType() != null && rendered.getMimeType().startsWith("text/")) {
                    HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
                    request.setAttribute("inline", (Object)"true");
                }
                ComponentUtils.download((DocumentModel)doc, null, (Blob)rendered, (String)rendered.getFilename(), (String)"rendition", Collections.singletonMap("rendition", renditionName));
            } else {
                HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
                response.sendError(404, "Unable to find rendition " + renditionName);
            }
        }
    }
}

