/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture;

import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CloseableFile;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.BlobWrapper;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.platform.actions.ActionContext;
import org.nuxeo.ecm.platform.actions.ELActionContext;
import org.nuxeo.ecm.platform.actions.ejb.ActionManager;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandException;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;
import org.nuxeo.ecm.platform.mimetype.MimetypeDetectionException;
import org.nuxeo.ecm.platform.mimetype.MimetypeNotFoundException;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.platform.picture.PictureConversionRegistry;
import org.nuxeo.ecm.platform.picture.PictureMigrationHandler;
import org.nuxeo.ecm.platform.picture.api.ImageInfo;
import org.nuxeo.ecm.platform.picture.api.ImagingConfigurationDescriptor;
import org.nuxeo.ecm.platform.picture.api.ImagingService;
import org.nuxeo.ecm.platform.picture.api.PictureConversion;
import org.nuxeo.ecm.platform.picture.api.PictureView;
import org.nuxeo.ecm.platform.picture.api.PictureViewImpl;
import org.nuxeo.ecm.platform.picture.core.libraryselector.LibrarySelector;
import org.nuxeo.ecm.platform.picture.magick.utils.ImageIdentifier;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class ImagingComponent
extends DefaultComponent
implements ImagingService {
    private static final Log log = LogFactory.getLog(ImagingComponent.class);
    public static final String CONFIGURATION_PARAMETERS_EP = "configuration";
    public static final String PICTURE_CONVERSIONS_EP = "pictureConversions";
    protected Map<String, String> configurationParameters = new HashMap<String, String>();
    protected PictureConversionRegistry pictureConversionRegistry = new PictureConversionRegistry();
    private LibrarySelector librarySelector;
    protected final PictureMigrationHandler pictureMigrationHandler = new PictureMigrationHandler();

    public List<PictureConversion> getPictureConversions() {
        return this.pictureConversionRegistry.getPictureConversions();
    }

    public PictureConversion getPictureConversion(String id) {
        return this.pictureConversionRegistry.getPictureConversion(id);
    }

    public Blob crop(Blob blob, int x, int y, int width, int height) {
        return this.getLibrarySelectorService().getImageUtils().crop(blob, x, y, width, height);
    }

    public Blob resize(Blob blob, String finalFormat, int width, int height, int depth) {
        return this.getLibrarySelectorService().getImageUtils().resize(blob, finalFormat, width, height, depth);
    }

    public Blob rotate(Blob blob, int angle) {
        return this.getLibrarySelectorService().getImageUtils().rotate(blob, angle);
    }

    public Map<String, Object> getImageMetadata(Blob blob) {
        log.warn((Object)"org.nuxeo.ecm.platform.picture.ImagingComponent.getImageMetadata is deprecated. Please use org.nuxeo.binary.metadata.api.BinaryMetadataService#readMetadata(org.nuxeo.ecm.core.api.Blob)");
        return Collections.emptyMap();
    }

    public String getImageMimeType(File file) {
        try {
            MimetypeRegistry mimetypeRegistry = (MimetypeRegistry)Framework.getLocalService(MimetypeRegistry.class);
            if (file.getName() != null) {
                return mimetypeRegistry.getMimetypeFromFilenameAndBlobWithDefault(file.getName(), Blobs.createBlob((File)file), "image/jpeg");
            }
            return mimetypeRegistry.getMimetypeFromFile(file);
        }
        catch (IOException | MimetypeDetectionException | MimetypeNotFoundException e) {
            log.error((Object)"Unable to retrieve mime type", e);
            return null;
        }
    }

    public String getImageMimeType(Blob blob) {
        try {
            MimetypeRegistry mimetypeRegistry = (MimetypeRegistry)Framework.getLocalService(MimetypeRegistry.class);
            if (blob.getFilename() != null) {
                return mimetypeRegistry.getMimetypeFromFilenameAndBlobWithDefault(blob.getFilename(), blob, "image/jpeg");
            }
            return mimetypeRegistry.getMimetypeFromBlob(blob);
        }
        catch (MimetypeDetectionException | MimetypeNotFoundException e) {
            log.error((Object)"Unable to retrieve mime type", e);
            return null;
        }
    }

    private LibrarySelector getLibrarySelectorService() {
        if (this.librarySelector == null) {
            this.librarySelector = (LibrarySelector)Framework.getRuntime().getService(LibrarySelector.class);
        }
        if (this.librarySelector == null) {
            log.error((Object)"Unable to get LibrarySelector runtime service");
            throw new NuxeoException("Unable to get LibrarySelector runtime service");
        }
        return this.librarySelector;
    }

    public ImageInfo getImageInfo(Blob blob) {
        ImageInfo imageInfo = null;
        try {
            String ext = blob.getFilename() == null ? ".tmp" : "." + FilenameUtils.getExtension((String)blob.getFilename());
            try (CloseableFile cf = blob.getCloseableFile(ext);){
                imageInfo = ImageIdentifier.getInfo(cf.getFile().getCanonicalPath());
            }
        }
        catch (CommandException | CommandNotAvailable e) {
            log.error((Object)("Failed to get ImageInfo for file " + blob.getFilename()), e);
        }
        catch (IOException e) {
            log.error((Object)("Failed to transfer file " + blob.getFilename()), (Throwable)e);
        }
        return imageInfo;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (CONFIGURATION_PARAMETERS_EP.equals(extensionPoint)) {
            ImagingConfigurationDescriptor desc = (ImagingConfigurationDescriptor)contribution;
            this.configurationParameters.putAll(desc.getParameters());
        } else if (PICTURE_CONVERSIONS_EP.equals(extensionPoint)) {
            this.pictureConversionRegistry.addContribution((PictureConversion)contribution);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (CONFIGURATION_PARAMETERS_EP.equals(extensionPoint)) {
            ImagingConfigurationDescriptor desc = (ImagingConfigurationDescriptor)contribution;
            for (String configuration : desc.getParameters().keySet()) {
                this.configurationParameters.remove(configuration);
            }
        } else if (PICTURE_CONVERSIONS_EP.equals(extensionPoint)) {
            this.pictureConversionRegistry.removeContribution((PictureConversion)contribution);
        }
    }

    public String getConfigurationValue(String configurationName) {
        return this.configurationParameters.get(configurationName);
    }

    public String getConfigurationValue(String configurationName, String defaultValue) {
        return this.configurationParameters.containsKey(configurationName) ? this.configurationParameters.get(configurationName) : defaultValue;
    }

    public void setConfigurationValue(String configurationName, String configurationValue) {
        this.configurationParameters.put(configurationName, configurationValue);
    }

    public PictureView computeViewFor(Blob blob, PictureConversion pictureConversion, boolean convert) throws IOException {
        return this.computeViewFor(blob, pictureConversion, null, convert);
    }

    public PictureView computeViewFor(Blob blob, PictureConversion pictureConversion, ImageInfo imageInfo, boolean convert) throws IOException {
        String mimeType = blob.getMimeType();
        if (mimeType == null) {
            blob.setMimeType(this.getImageMimeType(blob));
        }
        if (imageInfo == null) {
            imageInfo = this.getImageInfo(blob);
        }
        return this.computeView(blob, pictureConversion, imageInfo, convert);
    }

    public List<PictureView> computeViewsFor(Blob blob, List<PictureConversion> pictureConversions, boolean convert) throws IOException {
        return this.computeViewsFor(blob, pictureConversions, null, convert);
    }

    public List<PictureView> computeViewsFor(Blob blob, List<PictureConversion> pictureConversions, ImageInfo imageInfo, boolean convert) throws IOException {
        String mimeType = blob.getMimeType();
        if (mimeType == null) {
            blob.setMimeType(this.getImageMimeType(blob));
        }
        if (imageInfo == null) {
            imageInfo = this.getImageInfo(blob);
        }
        ArrayList<PictureView> views = new ArrayList<PictureView>();
        for (PictureConversion pictureConversion : pictureConversions) {
            views.add(this.computeView(blob, pictureConversion, imageInfo, convert));
        }
        return views;
    }

    protected PictureView computeView(Blob blob, PictureConversion pictureConversion, ImageInfo imageInfo, boolean convert) throws IOException {
        return this.computeView(null, blob, pictureConversion, imageInfo, convert);
    }

    protected PictureView computeView(DocumentModel doc, Blob blob, PictureConversion pictureConversion, ImageInfo imageInfo, boolean convert) throws IOException {
        if (convert) {
            return this.computeView(doc, blob, pictureConversion, imageInfo);
        }
        return this.computeViewWithoutConversion(blob, pictureConversion, imageInfo);
    }

    @Deprecated
    protected PictureView computeOriginalView(Blob blob, PictureConversion pictureConversion, ImageInfo imageInfo) throws IOException {
        String filename = blob.getFilename();
        String title = pictureConversion.getId();
        String viewFilename = title + "_" + filename;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("title", pictureConversion.getId());
        map.put("description", pictureConversion.getDescription());
        map.put("filename", viewFilename);
        map.put("tag", pictureConversion.getTag());
        map.put("width", imageInfo.getWidth());
        map.put("height", imageInfo.getHeight());
        Blob originalViewBlob = this.wrapBlob(blob);
        originalViewBlob.setFilename(viewFilename);
        map.put("content", (Serializable)originalViewBlob);
        map.put("info", imageInfo);
        return new PictureViewImpl(map);
    }

    protected Blob wrapBlob(Blob blob) {
        return new BlobWrapper(blob);
    }

    @Deprecated
    protected PictureView computeOriginalJpegView(Blob blob, PictureConversion pictureConversion, ImageInfo imageInfo) throws IOException {
        String filename = blob.getFilename();
        String title = pictureConversion.getId();
        int width = imageInfo.getWidth();
        int height = imageInfo.getHeight();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("title", pictureConversion.getId());
        map.put("description", pictureConversion.getDescription());
        map.put("tag", pictureConversion.getTag());
        map.put("width", width);
        map.put("height", height);
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("width", width);
        options.put("height", height);
        options.put("depth", imageInfo.getDepth());
        options.put("conversionFormat", "jpg");
        SimpleBlobHolder bh = new SimpleBlobHolder(blob);
        ConversionService conversionService = (ConversionService)Framework.getLocalService(ConversionService.class);
        bh = conversionService.convert("pictureResize", (BlobHolder)bh, options);
        Blob originalJpegBlob = bh.getBlob();
        if (originalJpegBlob == null) {
            originalJpegBlob = this.wrapBlob(blob);
        }
        String viewFilename = String.format("%s_%s.%s", title, FilenameUtils.getBaseName((String)blob.getFilename()), FilenameUtils.getExtension((String)"jpg"));
        map.put("filename", viewFilename);
        originalJpegBlob.setFilename(viewFilename);
        map.put("content", (Serializable)originalJpegBlob);
        map.put("info", this.getImageInfo(originalJpegBlob));
        return new PictureViewImpl(map);
    }

    @Deprecated
    protected String computeViewFilename(String filename, String format) {
        int index = filename.lastIndexOf(".");
        if (index == -1) {
            return filename + "." + format;
        }
        return filename.substring(0, index + 1) + format;
    }

    protected PictureView computeView(DocumentModel doc, Blob blob, PictureConversion pictureConversion, ImageInfo imageInfo) {
        String title = pictureConversion.getId();
        HashMap<String, Object> pictureViewMap = new HashMap<String, Object>();
        pictureViewMap.put("title", title);
        pictureViewMap.put("description", pictureConversion.getDescription());
        pictureViewMap.put("tag", pictureConversion.getTag());
        Point size = new Point(imageInfo.getWidth(), imageInfo.getHeight());
        if (pictureConversion.getMaxSize() != null) {
            size = ImagingComponent.getSize(size, pictureConversion.getMaxSize());
        }
        pictureViewMap.put("width", size.x);
        pictureViewMap.put("height", size.y);
        String conversionFormat = this.getConfigurationValue("conversionFormat", "jpg");
        Blob viewBlob = this.callPictureConversionChain(doc, blob, pictureConversion, imageInfo, size, conversionFormat);
        String viewFilename = String.format("%s_%s.%s", title, FilenameUtils.getBaseName((String)blob.getFilename()), FilenameUtils.getExtension((String)viewBlob.getFilename()));
        viewBlob.setFilename(viewFilename);
        pictureViewMap.put("filename", viewFilename);
        pictureViewMap.put("content", (Serializable)viewBlob);
        pictureViewMap.put("info", this.getImageInfo(viewBlob));
        return new PictureViewImpl(pictureViewMap);
    }

    protected Blob callPictureConversionChain(DocumentModel doc, Blob blob, PictureConversion pictureConversion, ImageInfo imageInfo, Point size, String conversionFormat) {
        String chainId = pictureConversion.getChainId();
        if (StringUtils.isBlank((String)chainId)) {
            return this.wrapBlob(blob);
        }
        Properties parameters = new Properties();
        parameters.put((Object)"width", (Object)String.valueOf(size.x));
        parameters.put((Object)"height", (Object)String.valueOf(size.y));
        parameters.put((Object)"depth", (Object)String.valueOf(imageInfo.getDepth()));
        parameters.put((Object)"conversionFormat", (Object)conversionFormat);
        HashMap<String, Properties> chainParameters = new HashMap<String, Properties>();
        chainParameters.put("parameters", parameters);
        OperationContext context = new OperationContext();
        if (doc != null) {
            DocumentModel pictureDocument = doc.getCoreSession().getDocument(doc.getRef());
            pictureDocument.detach(true);
            context.put("pictureDocument", (Object)pictureDocument);
        }
        context.setInput((Object)blob);
        boolean txWasActive = false;
        try {
            Blob viewBlob;
            if (TransactionHelper.isTransactionActive()) {
                txWasActive = true;
                TransactionHelper.commitOrRollbackTransaction();
            }
            if ((viewBlob = (Blob)((AutomationService)Framework.getService(AutomationService.class)).run(context, chainId, chainParameters)) == null) {
                viewBlob = this.wrapBlob(blob);
            }
            Blob blob2 = viewBlob;
            return blob2;
        }
        catch (OperationException e) {
            throw new NuxeoException((Throwable)e);
        }
        finally {
            if (txWasActive && !TransactionHelper.isTransactionActiveOrMarkedRollback()) {
                TransactionHelper.startTransaction();
            }
        }
    }

    public List<PictureView> computeViewsFor(DocumentModel doc, Blob blob, ImageInfo imageInfo, boolean convert) throws IOException {
        List<PictureConversion> pictureConversions = this.getPictureConversions();
        ArrayList<PictureView> pictureViews = new ArrayList<PictureView>(pictureConversions.size());
        for (PictureConversion pictureConversion : pictureConversions) {
            if (!this.canApplyPictureConversion(pictureConversion, doc)) continue;
            PictureView pictureView = this.computeView(doc, blob, pictureConversion, imageInfo, convert);
            pictureViews.add(pictureView);
        }
        return pictureViews;
    }

    protected boolean canApplyPictureConversion(PictureConversion pictureConversion, DocumentModel doc) {
        if (pictureConversion.isDefault()) {
            return true;
        }
        ActionManager actionService = (ActionManager)Framework.getService(ActionManager.class);
        return actionService.checkFilters(pictureConversion.getFilterIds(), this.createActionContext(doc));
    }

    protected ActionContext createActionContext(DocumentModel doc) {
        ELActionContext actionContext = new ELActionContext();
        actionContext.setCurrentDocument(doc);
        return actionContext;
    }

    protected PictureView computeViewWithoutConversion(Blob blob, PictureConversion pictureConversion, ImageInfo imageInfo) {
        PictureViewImpl view = new PictureViewImpl();
        view.setBlob(blob);
        view.setWidth(imageInfo.getWidth());
        view.setHeight(imageInfo.getHeight());
        view.setFilename(blob.getFilename());
        view.setTitle(pictureConversion.getId());
        view.setDescription(pictureConversion.getDescription());
        view.setTag(pictureConversion.getTag());
        view.setImageInfo(imageInfo);
        return view;
    }

    protected static Point getSize(Point current, int max) {
        int newX;
        int newY;
        int x = current.x;
        int y = current.y;
        if (x > y) {
            newY = y * max / x;
            newX = max;
        } else {
            newX = x * max / y;
            newY = max;
        }
        if (newX > x || newY > y) {
            return current;
        }
        return new Point(newX, newY);
    }

    public List<List<PictureView>> computeViewsFor(List<Blob> blobs, List<PictureConversion> pictureConversions, boolean convert) throws IOException {
        return this.computeViewsFor(blobs, pictureConversions, null, convert);
    }

    public List<List<PictureView>> computeViewsFor(List<Blob> blobs, List<PictureConversion> pictureConversions, ImageInfo imageInfo, boolean convert) throws IOException {
        ArrayList<List<PictureView>> allViews = new ArrayList<List<PictureView>>();
        for (Blob blob : blobs) {
            allViews.add(this.computeViewsFor(blob, pictureConversions, imageInfo, convert));
        }
        return allViews;
    }

    public void activate(ComponentContext context) {
        this.pictureMigrationHandler.install();
    }

    public void deactivate(ComponentContext context) {
        this.pictureMigrationHandler.uninstall();
    }
}

