/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.JDBCUtils;
import org.nuxeo.ecm.core.cache.CacheService;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.storage.sql.ColumnType;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;
import org.nuxeo.ecm.directory.AbstractDirectory;
import org.nuxeo.ecm.directory.BaseDirectoryDescriptor;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.sql.SQLDirectoryDescriptor;
import org.nuxeo.ecm.directory.sql.SQLHelper;
import org.nuxeo.ecm.directory.sql.SQLSession;
import org.nuxeo.ecm.directory.sql.SimpleDataSource;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.datasource.ConnectionHelper;
import org.nuxeo.runtime.datasource.DataSourceHelper;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class SQLDirectory
extends AbstractDirectory {
    public static final Log log = LogFactory.getLog(SQLDirectory.class);
    public static final String TENANT_ID_FIELD = "tenantId";
    private final boolean nativeCase;
    private DataSource dataSource;
    private Table table;
    private Schema schema;
    private Map<String, Field> schemaFieldMap;
    private List<String> storedFieldNames;
    private volatile Dialect dialect;

    public SQLDirectory(SQLDirectoryDescriptor descriptor) {
        super((BaseDirectoryDescriptor)descriptor);
        this.nativeCase = Boolean.TRUE.equals(descriptor.nativeCase);
        this.addReferences(descriptor.getInverseReferences());
        this.addReferences(descriptor.getTableReferences());
        this.cache.setEntryCacheName(descriptor.cacheEntryName);
        this.cache.setEntryCacheWithoutReferencesName(descriptor.cacheEntryWithoutReferencesName);
        this.cache.setNegativeCaching(descriptor.negativeCaching);
        CacheService cacheService = (CacheService)Framework.getLocalService(CacheService.class);
        if (cacheService != null) {
            if (descriptor.cacheEntryName == null && descriptor.getCacheMaxSize() != 0) {
                this.cache.setEntryCacheName("cache-" + this.getName());
                cacheService.registerCache("cache-" + this.getName(), descriptor.getCacheMaxSize(), descriptor.getCacheTimeout() / 60);
            }
            if (descriptor.cacheEntryWithoutReferencesName == null && descriptor.getCacheMaxSize() != 0) {
                this.cache.setEntryCacheWithoutReferencesName("cacheWithoutReference-" + this.getName());
                cacheService.registerCache("cacheWithoutReference-" + this.getName(), descriptor.getCacheMaxSize(), descriptor.getCacheTimeout() / 60);
            }
        }
    }

    public SQLDirectoryDescriptor getDescriptor() {
        return (SQLDirectoryDescriptor)this.descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initConnection() {
        SQLDirectoryDescriptor descriptor = this.getDescriptor();
        Connection sqlConnection = this.getConnection();
        try {
            this.dialect = Dialect.createDialect((Connection)sqlConnection, null);
            this.table = SQLHelper.addTable(descriptor.tableName, this.dialect, this.useNativeCase());
            SchemaManager schemaManager = (SchemaManager)Framework.getLocalService(SchemaManager.class);
            this.schema = schemaManager.getSchema(this.getSchema());
            if (this.schema == null) {
                throw new DirectoryException("schema not found: " + this.getSchema());
            }
            this.schemaFieldMap = new LinkedHashMap<String, Field>();
            this.storedFieldNames = new LinkedList<String>();
            boolean hasPrimary = false;
            for (Field f : this.schema.getFields()) {
                String fieldName = f.getName().getLocalName();
                this.schemaFieldMap.put(fieldName, f);
                if (this.isReference(fieldName)) continue;
                this.storedFieldNames.add(fieldName);
                boolean isId = fieldName.equals(this.getIdField());
                ColumnType type = ColumnType.fromField((Field)f);
                if (isId && descriptor.isAutoincrementIdField()) {
                    type = ColumnType.AUTOINC;
                }
                Column column = SQLHelper.addColumn(this.table, fieldName, type, this.useNativeCase());
                if (!isId) continue;
                if (descriptor.isAutoincrementIdField()) {
                    column.setIdentity(true);
                }
                column.setPrimary(true);
                column.setNullable(false);
                hasPrimary = true;
            }
            if (!hasPrimary) {
                throw new DirectoryException(String.format("Directory '%s' id field '%s' is not present in schema '%s'", this.getName(), this.getIdField(), this.getSchema()));
            }
            SQLHelper helper = new SQLHelper(sqlConnection, this.table, descriptor.dataFileName, descriptor.getDataFileCharacterSeparator(), descriptor.createTablePolicy);
            helper.setupTable();
        }
        finally {
            try {
                sqlConnection.close();
            }
            catch (SQLException e) {
                throw new DirectoryException((Throwable)e);
            }
        }
    }

    protected DataSource getDataSource() throws DirectoryException {
        if (this.dataSource != null) {
            return this.dataSource;
        }
        SQLDirectoryDescriptor descriptor = this.getDescriptor();
        try {
            this.dataSource = !StringUtils.isEmpty((String)descriptor.dataSourceName) ? DataSourceHelper.getDataSource((String)descriptor.dataSourceName) : new SimpleDataSource(descriptor.dbUrl, descriptor.dbDriver, descriptor.dbUser, descriptor.dbPassword);
            log.trace((Object)("found datasource: " + this.dataSource));
            return this.dataSource;
        }
        catch (NamingException e) {
            log.error((Object)"dataSource lookup failed", (Throwable)e);
            throw new DirectoryException("dataSource lookup failed", (Throwable)e);
        }
    }

    public Connection getConnection() throws DirectoryException {
        SQLDirectoryDescriptor descriptor = this.getDescriptor();
        try {
            Connection connection;
            if (!StringUtils.isEmpty((String)descriptor.dataSourceName) && (connection = ConnectionHelper.getConnection((String)descriptor.dataSourceName)) != null) {
                if (ConnectionHelper.useSingleConnection((String)descriptor.dataSourceName)) {
                    connection.setAutoCommit(TransactionHelper.isNoTransaction());
                }
                return connection;
            }
            return this.getConnection(this.getDataSource());
        }
        catch (SQLException e) {
            throw new DirectoryException("Cannot connect to SQL directory '" + this.getName() + "': " + e.getMessage(), (Throwable)e);
        }
    }

    protected Connection getConnection(DataSource aDataSource) throws SQLException {
        return JDBCUtils.getConnection((DataSource)aDataSource);
    }

    public Session getSession() throws DirectoryException {
        this.checkConnection();
        SQLSession session = new SQLSession(this, this.getDescriptor());
        this.addSession(session);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkConnection() {
        if (this.dialect == null) {
            SQLDirectory sQLDirectory = this;
            synchronized (sQLDirectory) {
                if (this.dialect == null) {
                    this.initConnection();
                }
            }
        }
    }

    protected void addSession(SQLSession session) throws DirectoryException {
        super.addSession((Session)session);
        this.registerInTx(session);
    }

    protected void registerInTx(SQLSession session) throws DirectoryException {
        if (!TransactionHelper.isTransactionActive()) {
            return;
        }
        try {
            ConnectionHelper.registerSynchronization((Synchronization)new TxSessionCleaner(session));
        }
        catch (SystemException e) {
            throw new DirectoryException("Cannot register in tx for session cleanup handling " + (Object)((Object)this), (Throwable)e);
        }
    }

    public Map<String, Field> getSchemaFieldMap() {
        return this.schemaFieldMap;
    }

    public List<String> getStoredFieldNames() {
        return this.storedFieldNames;
    }

    public Table getTable() {
        return this.table;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public boolean useNativeCase() {
        return this.nativeCase;
    }

    public boolean isMultiTenant() {
        return this.table.getColumn(TENANT_ID_FIELD) != null;
    }

    public String toString() {
        return "SQLDirectory [name=" + this.descriptor.name + "]";
    }

    protected class TxSessionCleaner
    implements Synchronization {
        private final SQLSession session;
        Throwable initContext = this.captureInitContext();

        protected TxSessionCleaner(SQLSession session) {
            this.session = session;
        }

        protected Throwable captureInitContext() {
            if (!log.isDebugEnabled()) {
                return null;
            }
            return new Throwable("SQL directory session init context in " + (Object)((Object)SQLDirectory.this));
        }

        protected void checkIsNotLive() {
            try {
                if (!this.session.isLive()) {
                    return;
                }
                if (this.initContext != null) {
                    log.warn((Object)("Closing a sql directory session for you " + (Object)((Object)this.session)), this.initContext);
                } else {
                    log.warn((Object)("Closing a sql directory session for you " + (Object)((Object)this.session)));
                }
                if (!TransactionHelper.isTransactionActiveOrMarkedRollback()) {
                    log.warn((Object)("Closing sql directory session outside a transaction" + (Object)((Object)this.session)));
                }
                this.session.close();
            }
            catch (DirectoryException e) {
                log.error((Object)("Cannot state on sql directory session before commit " + (Object)((Object)SQLDirectory.this)), (Throwable)e);
            }
        }

        public void beforeCompletion() {
            this.checkIsNotLive();
        }

        public void afterCompletion(int status) {
            this.checkIsNotLive();
        }
    }
}

