/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.web.common.exceptionhandling;

import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletException;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.io.download.DownloadHelper;

public class ExceptionHelper {
    public static List<String> possibleSecurityErrorMessages = Arrays.asList("java.lang.SecurityException", DocumentSecurityException.class.getName(), SecurityException.class.getName());

    private ExceptionHelper() {
    }

    public static Throwable unwrapException(Throwable t) {
        Throwable cause = null;
        if (t instanceof ServletException) {
            cause = ((ServletException)t).getRootCause();
        } else if (t instanceof Exception) {
            cause = t.getCause();
        }
        if (cause == null) {
            return t;
        }
        return ExceptionHelper.unwrapException(cause);
    }

    public static boolean isSecurityError(Throwable t) {
        if (t == null) {
            return false;
        }
        if (t instanceof DocumentSecurityException || t.getCause() instanceof DocumentSecurityException || t.getCause() instanceof SecurityException) {
            return true;
        }
        if (t.getMessage() != null) {
            String message = t.getMessage();
            for (String errorMessage : possibleSecurityErrorMessages) {
                if (!message.contains(errorMessage)) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public static boolean isClientAbortError(Throwable t) {
        return DownloadHelper.isClientAbortError((Throwable)t);
    }

    @Deprecated
    public static void logClientAbort(Exception e) {
        DownloadHelper.logClientAbort((Exception)e);
    }
}

