/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.impl;

import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class OperationTypeRegistry
extends ContributionFragmentRegistry<OperationType> {
    protected final Map<String, OperationType> operations = new HashMap<String, OperationType>();
    protected volatile Map<String, OperationType> lookup;

    public String getContributionId(OperationType contrib) {
        return contrib.getId();
    }

    public synchronized void addContribution(OperationType op, boolean replace) throws OperationException {
        if (!replace && this.operations.containsKey(op.getId())) {
            throw new OperationException("An operation is already bound to: " + op.getId() + ". Use 'replace=true' to replace an existing operation");
        }
        super.addContribution((Object)op);
    }

    public void contributionUpdated(String id, OperationType contrib, OperationType newOrigContrib) {
        this.operations.put(id, contrib);
        for (String alias : contrib.getAliases()) {
            this.operations.put(alias, contrib);
        }
        this.lookup = null;
    }

    public void contributionRemoved(String id, OperationType origContrib) {
        this.operations.remove(id);
        this.lookup = null;
    }

    public boolean isSupportingMerge() {
        return false;
    }

    public OperationType clone(OperationType orig) {
        throw new UnsupportedOperationException();
    }

    public void merge(OperationType src, OperationType dst) {
        throw new UnsupportedOperationException();
    }

    public OperationType getOperationType(Class<?> key) {
        return this.operations.get(key.getAnnotation(Operation.class).id());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, OperationType> lookup() {
        Map<String, OperationType> _lookup = this.lookup;
        if (_lookup == null) {
            OperationTypeRegistry operationTypeRegistry = this;
            synchronized (operationTypeRegistry) {
                _lookup = this.lookup = new HashMap<String, OperationType>(this.operations);
            }
        }
        return _lookup;
    }
}

