/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.permissions;

import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.tokenauth.service.TokenAuthenticationService;
import org.nuxeo.runtime.api.Framework;

public class TransientUserPermissionHelper {
    private TransientUserPermissionHelper() {
    }

    public static String acquireToken(String username, DocumentModel doc, String permission) {
        if (NuxeoPrincipal.isTransientUsername((String)username)) {
            TokenAuthenticationService tokenAuthenticationService = (TokenAuthenticationService)Framework.getService(TokenAuthenticationService.class);
            return tokenAuthenticationService.acquireToken(username, doc.getRepositoryName(), doc.getId(), null, permission);
        }
        return null;
    }

    public static void revokeToken(String username, DocumentModel doc) {
        if (NuxeoPrincipal.isTransientUsername((String)username)) {
            ACP acp = doc.getACP();
            for (ACL acl : acp.getACLs()) {
                if ("inherited".equals(acl.getName())) continue;
                for (ACE ace : acl) {
                    if (!username.equals(ace.getUsername()) || ace.isArchived()) continue;
                    return;
                }
            }
            TokenAuthenticationService tokenAuthenticationService = (TokenAuthenticationService)Framework.getService(TokenAuthenticationService.class);
            String token = tokenAuthenticationService.getToken(username, doc.getRepositoryName(), doc.getId());
            if (token != null) {
                tokenAuthenticationService.revokeToken(token);
            }
        }
    }
}

