/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message;

import java.util.Arrays;
import javax.naming.NamingException;
import javax.naming.ldap.ExtendedResponse;
import org.apache.directory.shared.ldap.message.AbstractRequest;
import org.apache.directory.shared.ldap.message.ExtendedRequest;
import org.apache.directory.shared.ldap.message.ExtendedResponseImpl;
import org.apache.directory.shared.ldap.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.message.ResultResponse;
import org.apache.directory.shared.ldap.util.StringTools;

public class ExtendedRequestImpl
extends AbstractRequest
implements ExtendedRequest {
    static final long serialVersionUID = 7916990159044177480L;
    private String oid;
    protected byte[] payload;
    protected ResultResponse response;

    public ExtendedRequestImpl(int id) {
        super(id, TYPE, true);
    }

    public String getOid() {
        return this.oid;
    }

    public void setOid(String oid) {
        this.oid = oid;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
    }

    public MessageTypeEnum getResponseType() {
        return RESP_TYPE;
    }

    public ResultResponse getResultResponse() {
        if (this.response == null) {
            this.response = new ExtendedResponseImpl(this.getMessageId());
        }
        return this.response;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ExtendedRequest req = (ExtendedRequest)obj;
        if (this.oid != null && req.getOid() == null) {
            return false;
        }
        if (this.oid == null && req.getOid() != null) {
            return false;
        }
        if (this.oid != null && req.getOid() != null && !this.oid.equals(req.getOid())) {
            return false;
        }
        if (this.payload != null && req.getPayload() == null) {
            return false;
        }
        if (this.payload == null && req.getPayload() != null) {
            return false;
        }
        return this.payload == null || req.getPayload() == null || Arrays.equals(this.payload, req.getPayload());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Extended request\n");
        sb.append("        Request name : '").append(this.oid).append("'\n");
        if (this.oid != null) {
            sb.append("        Request value : '").append(StringTools.utf8ToString(this.payload)).append('/').append(StringTools.dumpBytes(this.payload)).append("'\n");
        }
        return sb.toString();
    }

    public String getID() {
        return this.getOid();
    }

    public byte[] getEncodedValue() {
        return this.getPayload();
    }

    public ExtendedResponse createExtendedResponse(String id, byte[] berValue, int offset, int length) throws NamingException {
        return null;
    }
}

