/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.ui.web.auth.digest;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.api.login.UserIdentificationInfo;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.NuxeoAuthenticationPlugin;

public class DigestAuthenticator
implements NuxeoAuthenticationPlugin {
    private static final Log log = LogFactory.getLog(DigestAuthenticator.class);
    protected static final String DEFAULT_REALMNAME = "NUXEO";
    protected static final long DEFAULT_NONCE_VALIDITY_SECONDS = 1000L;
    protected static final String EQUAL_SEPARATOR = "=";
    protected static final String QUOTE = "\"";
    protected static final Pattern PAIR_ITEM_PATTERN = Pattern.compile("^(.*?)=([\\s\"]*)?(.*)(\")?$");
    protected static final String REALM_NAME_KEY = "RealmName";
    protected static final String BA_HEADER_NAME = "WWW-Authenticate";
    protected String realmName;
    protected long nonceValiditySeconds = 1000L;
    protected String accessKey = "key";

    public Boolean handleLoginPrompt(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String baseURL) {
        long expiryTime = System.currentTimeMillis() + this.nonceValiditySeconds * 1000L;
        String signature = DigestUtils.md5Hex((String)(expiryTime + ":" + this.accessKey));
        String nonce = expiryTime + ":" + signature;
        String nonceB64 = new String(Base64.encodeBase64((byte[])nonce.getBytes()));
        String authenticateHeader = String.format("Digest realm=\"%s\", qop=\"auth\", nonce=\"%s\"", this.realmName, nonceB64);
        try {
            httpResponse.addHeader(BA_HEADER_NAME, authenticateHeader);
            httpResponse.sendError(401);
            return Boolean.TRUE;
        }
        catch (IOException e) {
            return Boolean.FALSE;
        }
    }

    public UserIdentificationInfo handleRetrieveIdentity(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        String header = httpRequest.getHeader("Authorization");
        String DIGEST_PREFIX = "digest ";
        if (StringUtils.isEmpty((String)header) || !header.toLowerCase().startsWith(DIGEST_PREFIX)) {
            return null;
        }
        Map<String, String> headerMap = DigestAuthenticator.splitParameters(header.substring(DIGEST_PREFIX.length()));
        headerMap.put("httpMethod", httpRequest.getMethod());
        String nonceB64 = headerMap.get("nonce");
        String nonce = new String(Base64.decodeBase64((byte[])nonceB64.getBytes()));
        String[] nonceTokens = nonce.split(":");
        long nonceExpiryTime = Long.parseLong(nonceTokens[0]);
        String username = headerMap.get("username");
        String responseDigest = headerMap.get("response");
        UserIdentificationInfo userIdent = new UserIdentificationInfo(username, responseDigest);
        userIdent.setLoginParameters(headerMap);
        return userIdent;
    }

    public Boolean needLoginPrompt(HttpServletRequest httpRequest) {
        return Boolean.TRUE;
    }

    public void initPlugin(Map<String, String> parameters) {
        this.realmName = parameters.containsKey(REALM_NAME_KEY) ? parameters.get(REALM_NAME_KEY) : DEFAULT_REALMNAME;
    }

    public List<String> getUnAuthenticatedURLPrefix() {
        return null;
    }

    public static Map<String, String> splitParameters(String auth) {
        HashMap<String, String> map = new HashMap<String, String>();
        try (CSVParser reader = new CSVParser((Reader)new StringReader(auth), CSVFormat.DEFAULT);){
            Iterator iterator = reader.iterator();
            if (iterator.hasNext()) {
                CSVRecord record = (CSVRecord)iterator.next();
                for (String itemPairStr : record) {
                    String[] parts = (itemPairStr = StringUtils.remove((String)itemPairStr, (String)QUOTE)).split(EQUAL_SEPARATOR, 2);
                    if (parts == null) continue;
                    map.put(parts[0].trim(), parts[1].trim());
                }
            }
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return map;
    }
}

