/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.tag;

import java.util.List;
import org.nuxeo.ecm.core.query.QueryFilter;
import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.ecm.core.storage.sql.ColumnType;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.Session;
import org.nuxeo.ecm.core.storage.sql.jdbc.NXQLQueryMaker;
import org.nuxeo.ecm.core.storage.sql.jdbc.QueryMaker;
import org.nuxeo.ecm.core.storage.sql.jdbc.SQLInfo;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Select;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;

public class TagQueryMaker
extends NXQLQueryMaker {
    public static final String NXTAG = "NXTAG";
    public static final String SCHEMA_TAG = "tag";
    public static final String SCHEMA_RELATION = "relation";
    public static final String PROPERTY_SOURCE = "source";
    public static final String PROPERTY_TARGET = "target";
    public static final String TAG_IS_TARGET = "TAGISTARGET: ";
    public static final String COUNT_SOURCE = "COUNTSOURCE: ";
    protected String type;
    protected Table relationTable;
    protected Column firstSelectedColumn;

    public String getName() {
        return NXTAG;
    }

    public boolean accepts(String queryType) {
        return queryType.equals(NXTAG);
    }

    public QueryMaker.Query buildQuery(SQLInfo sqlInfo, Model model, Session.PathResolver pathResolver, String query, QueryFilter queryFilter, Object ... params) {
        if (query.startsWith(TAG_IS_TARGET)) {
            this.type = TAG_IS_TARGET;
        } else if (query.startsWith(COUNT_SOURCE)) {
            this.type = COUNT_SOURCE;
        } else {
            throw new QueryParseException("Bad query: " + query);
        }
        query = query.substring(this.type.length());
        return super.buildQuery(sqlInfo, model, pathResolver, query, queryFilter, params);
    }

    protected void fixInitialJoins() {
        this.relationTable = this.getFragmentTable(this.dataHierTable, SCHEMA_RELATION, SCHEMA_RELATION, -1, false);
    }

    protected void addJoin(int kind, String alias, Table table, String column, Table contextTable, String contextColumn, String name, int index, String primaryType) {
        if (table.getKey().equals(SCHEMA_TAG)) {
            kind = 1;
            contextTable = this.relationTable;
            contextColumn = PROPERTY_TARGET;
        }
        super.addJoin(kind, alias, table, column, contextTable, contextColumn, name, index, null);
    }

    protected String getSelectColName(Column col) {
        String name = super.getSelectColName(col);
        if (this.firstSelectedColumn == null) {
            this.firstSelectedColumn = col;
        }
        if (this.type == COUNT_SOURCE && col.getTable().getKey().equals(SCHEMA_RELATION) && col.getKey().equals(PROPERTY_SOURCE)) {
            name = String.format("COUNT(DISTINCT %s)", name);
        }
        return name;
    }

    protected void fixWhatColumns(List<Column> whatColumns) {
        if (this.type == COUNT_SOURCE) {
            Column targetCol = whatColumns.remove(1);
            Column countCol = new Column(targetCol.getTable(), null, ColumnType.INTEGER, null);
            whatColumns.add(countCol);
        }
    }

    protected void fixSelect(Select select) {
        if (this.type == COUNT_SOURCE) {
            String name = this.dialect.needsOriginalColumnInGroupBy() ? this.firstSelectedColumn.getFullQuotedName() : this.dialect.openQuote() + "_C" + "1" + this.dialect.closeQuote();
            select.setGroupBy(name);
        }
    }
}

