/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.jaxrs;

import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.webengine.jaxrs.ApplicationManager;
import org.nuxeo.ecm.webengine.jaxrs.servlet.config.ServletRegistry;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator,
ServiceTrackerCustomizer {
    private static final Log log = LogFactory.getLog(Activator.class);
    private static Activator instance;
    protected ServiceTracker httpServiceTracker;
    protected BundleContext context;
    protected ServiceReference pkgAdm;

    public static Activator getInstance() {
        return instance;
    }

    public void start(BundleContext context) {
        instance = this;
        this.context = context;
        this.pkgAdm = context.getServiceReference(PackageAdmin.class.getName());
        if (!"Nuxeo".equals(context.getProperty("org.osgi.framework.vendor"))) {
            this.httpServiceTracker = new ServiceTracker(context, HttpService.class.getName(), (ServiceTrackerCustomizer)this);
            this.httpServiceTracker.open();
        }
        ApplicationManager.getInstance().start(context);
    }

    public void stop(BundleContext context) {
        ApplicationManager.getInstance().stop(context);
        if (this.httpServiceTracker != null) {
            this.httpServiceTracker.close();
            this.httpServiceTracker = null;
        }
        ServletRegistry.dispose();
        instance = null;
        context.ungetService(this.pkgAdm);
        this.pkgAdm = null;
        this.context = null;
    }

    public BundleContext getContext() {
        return this.context;
    }

    public PackageAdmin getPackageAdmin() {
        return (PackageAdmin)this.context.getService(this.pkgAdm);
    }

    public Object addingService(ServiceReference reference) {
        Object service = this.context.getService(reference);
        try {
            if (service instanceof HttpService) {
                ServletRegistry.getInstance().initHttpService((HttpService)service);
            }
        }
        catch (ServletException | NamespaceException e) {
            throw new RuntimeException("Failed to initialize http service", e);
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference reference, Object service) {
        try {
            if (ServletRegistry.getInstance().getHttpService() == service) {
                ServletRegistry.getInstance().initHttpService(null);
            }
        }
        catch (ServletException | NamespaceException e) {
            log.error((Object)"Failed to remove http service", e);
        }
        finally {
            this.context.ungetService(reference);
        }
    }

    public void modifiedService(ServiceReference reference, Object service) {
        try {
            if (ServletRegistry.getInstance().getHttpService() == service) {
                ServletRegistry.getInstance().initHttpService(null);
                ServletRegistry.getInstance().initHttpService((HttpService)service);
            }
        }
        catch (ServletException | NamespaceException e) {
            log.error((Object)"Failed to update http service", e);
        }
    }
}

