/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.ObjectUtils;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;

public class FulltextDescriptor {
    private Boolean fulltextDisabled;
    private Boolean fulltextSearchDisabled;
    private String fulltextParser;
    private List<FulltextIndexDescriptor> fulltextIndexes = new ArrayList<FulltextIndexDescriptor>(0);
    private Set<String> fulltextExcludedTypes = new HashSet<String>(0);
    private Set<String> fulltextIncludedTypes = new HashSet<String>(0);

    private static boolean defaultFalse(Boolean bool) {
        return Boolean.TRUE.equals(bool);
    }

    public boolean getFulltextDisabled() {
        return FulltextDescriptor.defaultFalse(this.fulltextDisabled);
    }

    public void setFulltextDisabled(boolean disabled) {
        this.fulltextDisabled = disabled;
    }

    public boolean getFulltextSearchDisabled() {
        if (this.getFulltextDisabled()) {
            return true;
        }
        return FulltextDescriptor.defaultFalse(this.fulltextSearchDisabled);
    }

    public void setFulltextSearchDisabled(boolean disabled) {
        this.fulltextSearchDisabled = disabled;
    }

    public String getFulltextParser() {
        return this.fulltextParser;
    }

    public void setFulltextParser(String fulltextParser) {
        this.fulltextParser = fulltextParser;
    }

    public List<FulltextIndexDescriptor> getFulltextIndexes() {
        return this.fulltextIndexes;
    }

    public void setFulltextIndexes(List<FulltextIndexDescriptor> fulltextIndexes) {
        this.fulltextIndexes = fulltextIndexes;
    }

    public Set<String> getFulltextExcludedTypes() {
        return this.fulltextExcludedTypes;
    }

    public void setFulltextExcludedTypes(Set<String> fulltextExcludedTypes) {
        this.fulltextExcludedTypes = fulltextExcludedTypes;
    }

    public Set<String> getFulltextIncludedTypes() {
        return this.fulltextIncludedTypes;
    }

    public void setFulltextIncludedTypes(Set<String> fulltextIncludedTypes) {
        this.fulltextIncludedTypes = fulltextIncludedTypes;
    }

    public FulltextDescriptor() {
    }

    public FulltextDescriptor(FulltextDescriptor other) {
        this.fulltextDisabled = other.fulltextDisabled;
        this.fulltextSearchDisabled = other.fulltextSearchDisabled;
        this.fulltextParser = other.fulltextParser;
        this.fulltextIndexes = FulltextIndexDescriptor.copyList(other.fulltextIndexes);
        this.fulltextExcludedTypes = new HashSet<String>(other.fulltextExcludedTypes);
        this.fulltextIncludedTypes = new HashSet<String>(other.fulltextIncludedTypes);
    }

    public void merge(FulltextDescriptor other) {
        if (other.fulltextDisabled != null) {
            this.fulltextDisabled = other.fulltextDisabled;
        }
        if (other.fulltextSearchDisabled != null) {
            this.fulltextSearchDisabled = other.fulltextSearchDisabled;
        }
        if (other.fulltextParser != null) {
            this.fulltextParser = other.fulltextParser;
        }
        for (FulltextIndexDescriptor oi : other.fulltextIndexes) {
            boolean append = true;
            for (FulltextIndexDescriptor i : this.fulltextIndexes) {
                if (!ObjectUtils.equals((Object)i.name, (Object)oi.name)) continue;
                i.merge(oi);
                append = false;
                break;
            }
            if (!append) continue;
            this.fulltextIndexes.add(oi);
        }
        this.fulltextExcludedTypes.addAll(other.fulltextExcludedTypes);
        this.fulltextIncludedTypes.addAll(other.fulltextIncludedTypes);
    }

    @XObject(value="index")
    public static class FulltextIndexDescriptor {
        @XNode(value="@name")
        public String name;
        @XNode(value="fieldType")
        public String fieldType;
        @XNodeList(value="field", type=HashSet.class, componentType=String.class)
        public Set<String> fields = new HashSet<String>(0);
        @XNodeList(value="excludeField", type=HashSet.class, componentType=String.class)
        public Set<String> excludeFields = new HashSet<String>(0);

        public FulltextIndexDescriptor() {
        }

        public FulltextIndexDescriptor(FulltextIndexDescriptor other) {
            this.name = other.name;
            this.fieldType = other.fieldType;
            this.fields = new HashSet<String>(other.fields);
            this.excludeFields = new HashSet<String>(other.excludeFields);
        }

        public static List<FulltextIndexDescriptor> copyList(List<FulltextIndexDescriptor> other) {
            ArrayList<FulltextIndexDescriptor> copy = new ArrayList<FulltextIndexDescriptor>(other.size());
            for (FulltextIndexDescriptor fid : other) {
                copy.add(new FulltextIndexDescriptor(fid));
            }
            return copy;
        }

        public void merge(FulltextIndexDescriptor other) {
            if (other.name != null) {
                this.name = other.name;
            }
            if (other.fieldType != null) {
                this.fieldType = other.fieldType;
            }
            this.fields.addAll(other.fields);
            this.excludeFields.addAll(other.excludeFields);
        }
    }
}

