/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.listener;

import java.io.Serializable;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;

public class DocumentRoutingUpdateCommentsInfoListener
implements EventListener {
    public void handleEvent(Event event) {
        String eventId = event.getName();
        if (!eventId.equals("commentAdded") && !eventId.equals("commentRemoved")) {
            return;
        }
        if (!(event.getContext() instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext docCtx = (DocumentEventContext)event.getContext();
        DocumentModel doc = docCtx.getSourceDocument();
        if (!doc.hasFacet("CommentsInfoHolder")) {
            return;
        }
        Long comments = (Long)doc.getPropertyValue("info_comments:numberOfComments");
        if (eventId.equals("commentAdded")) {
            comments = comments + 1L;
            doc.setPropertyValue("info_comments:numberOfComments", (Serializable)comments);
        }
        if (eventId.equals("commentRemoved")) {
            comments = comments - 1L;
            doc.setPropertyValue("info_comments:numberOfComments", (Serializable)comments);
        }
        event.getContext().getCoreSession().saveDocument(doc);
    }
}

